/*
 * Decompiled with CFR 0.152.
 */
package stallone.intsequence;

import java.io.IOException;
import stallone.api.ints.IIntArray;
import stallone.api.ints.Ints;
import stallone.api.intsequence.IIntReader;
import stallone.api.strings.Strings;
import stallone.io.CachedAsciiFileReader;

public class IntSequenceReaderAsciiDense
extends CachedAsciiFileReader
implements IIntReader {
    private boolean scanned = false;
    private int dimension = 0;
    private int line = 0;

    public IntSequenceReaderAsciiDense() {
    }

    public IntSequenceReaderAsciiDense(String _file) throws IOException {
        super(_file);
        this.setSource(_file);
        this.open();
    }

    @Override
    public final void setSource(String _file) {
        if (!_file.equals(this.filename)) {
            this.filename = _file;
            this.scanned = false;
        }
    }

    @Override
    public final void open() throws IOException {
        super.open();
        this.scan();
    }

    @Override
    public final void scan() throws IOException {
        if (!this.scanned) {
            super.scan();
            this.scanned = true;
        }
    }

    @Override
    protected boolean scanLine(String textline, int currentLineNumber) {
        String[] words = Strings.util.split(textline);
        return words.length == 1;
    }

    @Override
    public int size() {
        return super.getNumberOfLines();
    }

    @Override
    public long memorySize() {
        return this.size() * 4;
    }

    @Override
    public int get(int i) {
        String strline = super.getLine(i);
        int res = 0;
        try {
            res = Strings.util.toInt(strline);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Line " + i + " of file " + this.filename + " is not an integer:\n " + strline);
        }
        return res;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public IIntArray load() {
        int size = this.size();
        IIntArray res = Ints.create.array(size);
        int i = 0;
        while (i < size) {
            res.set(i, this.get(i));
            ++i;
        }
        return res;
    }
}

