/*
 * Decompiled with CFR 0.152.
 */
package stallone.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import stallone.doubles.fastutils.LongArrayList;
import stallone.io.CachedRandomAccessFile;

public class CachedAsciiFileReader {
    public static Pattern commentLine = Pattern.compile("[;#].*|\\s*");
    public static Pattern whiteSpacePattern = Pattern.compile("\\s+");
    private static final Logger log = Logger.getLogger(CachedAsciiFileReader.class.getName());
    protected String filename;
    private boolean scanned = false;
    private CachedRandomAccessFile randomAccessFile;
    private int relevantLines;
    private long[] lineStartOffsets;
    private Pattern usedCommentPattern;

    public CachedAsciiFileReader() {
    }

    public CachedAsciiFileReader(String filename) throws FileNotFoundException, IOException {
        this(filename, null);
    }

    public CachedAsciiFileReader(String filename, Pattern commentPattern) throws FileNotFoundException, IOException {
        this.filename = filename;
        this.usedCommentPattern = commentPattern;
        this.randomAccessFile = new CachedRandomAccessFile(filename);
        this.lineStartOffsets = null;
    }

    public void setFilename(String _filename) {
        this.filename = _filename;
    }

    public void setCommentPattern(Pattern _commentPattern) {
        this.usedCommentPattern = _commentPattern;
    }

    public void open() throws IOException {
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
        }
        this.randomAccessFile = new CachedRandomAccessFile(this.filename);
        this.scanned = false;
    }

    public void scan() throws IOException {
        String textline;
        if (this.scanned) {
            return;
        }
        int INITIAL_SIZE = 1000000;
        LongArrayList lineOffsets = new LongArrayList(1000000);
        long currentPos = 0L;
        int currentLineNumber = 0;
        while ((textline = this.randomAccessFile.readLine()) != null) {
            long oldPos = currentPos;
            if (this.usedCommentPattern != null && this.usedCommentPattern.matcher(textline).matches()) continue;
            this.scanLine(textline, currentLineNumber);
            ++currentLineNumber;
            currentPos = this.randomAccessFile.getFilePointer();
            lineOffsets.add(oldPos);
        }
        this.scanEnd(currentLineNumber);
        lineOffsets.trim();
        this.lineStartOffsets = lineOffsets.toLongArray();
        this.relevantLines = this.lineStartOffsets.length;
        this.scanned = true;
    }

    public int getNumberOfLines() {
        return this.relevantLines;
    }

    public String getLine(int lineNumber) {
        if (this.lineStartOffsets == null) {
            throw new RuntimeException("No line offsets available, you need to call scan() first.");
        }
        try {
            if (lineNumber >= 0 && lineNumber < this.relevantLines) {
                this.randomAccessFile.seek(this.lineStartOffsets[lineNumber]);
                String line = this.randomAccessFile.readLine();
                return line;
            }
            throw new IllegalArgumentException("Requested line " + lineNumber + " is out of scope.");
        }
        catch (IOException ex) {
            Logger.getLogger(CachedAsciiFileReader.class.getName()).log(Level.SEVERE, "I/O error while requesting line " + lineNumber + " of file '" + this.filename + "'.", ex);
            throw new RuntimeException("I/O error while requesting line " + lineNumber + " of file '" + this.filename + "'.");
        }
    }

    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    protected boolean scanLine(String textline, int currentLineNumber) {
        return true;
    }

    protected void scanEnd(int currentLineNumber) {
    }
}

