/*
 * Decompiled with CFR 0.152.
 */
package stallone.io;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WildcardFilter
implements FileFilter {
    private Pattern compiledSearchPattern;

    public WildcardFilter(String searchPattern) {
        StringBuilder c = new StringBuilder("");
        Pattern nonWildcardBlock = Pattern.compile("[^#*?]+");
        int pos = 0;
        Matcher matcher = nonWildcardBlock.matcher(searchPattern);
        while (pos < searchPattern.length()) {
            if (searchPattern.charAt(pos) == '#') {
                c.append("\\d+");
                ++pos;
                continue;
            }
            if (searchPattern.charAt(pos) == '*') {
                c.append(".*");
                ++pos;
                continue;
            }
            if (searchPattern.charAt(pos) == '?') {
                c.append(".");
                ++pos;
                continue;
            }
            if (matcher.find(pos)) {
                String block = matcher.group();
                pos += block.length();
                c.append(Pattern.quote(block));
                continue;
            }
            throw new RuntimeException("This should never happen.");
        }
        this.compiledSearchPattern = Pattern.compile(c.toString());
    }

    @Override
    public boolean accept(File pathname) {
        return this.compiledSearchPattern.matcher(pathname.getName()).matches();
    }

    public static void main(String[] args) {
        File homeDir = new File("/home/fischbac");
        File[] fileArray = homeDir.listFiles(new WildcardFilter("*conf?"));
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            System.out.println(f.getAbsolutePath());
            ++n2;
        }
    }
}

