/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc;

import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.function.IGriddedFunction;
import stallone.api.ints.IIntArray;
import stallone.mc.MarkovChain;
import stallone.stat.DiscreteDistributions;

public class DiscretePotentialMetropolisMarkovChain
extends MarkovChain {
    public DiscretePotentialMetropolisMarkovChain(IGriddedFunction f, double kT) {
        IDoubleArray _T = Doubles.create.array(f.size(), f.size());
        int i = 0;
        while (i < f.size()) {
            IDoubleArray xi = f.get(i);
            double Ei = f.f(xi);
            IIntArray neighbors = f.getNeighborIndexes(i);
            double psum = 0.0;
            int j = 0;
            while (j < neighbors.size()) {
                int n = neighbors.get(j);
                IDoubleArray xj = f.get(neighbors.get(j));
                double Ej = f.f(xj);
                double pjump = 1.0 / (double)neighbors.size() * Math.min(1.0, Math.exp(-(Ej - Ei) / kT));
                psum += pjump;
                _T.set(i, n, pjump);
                ++j;
            }
            _T.set(i, i, 1.0 - psum);
            ++i;
        }
        this.T = _T;
        this.dd = new DiscreteDistributions(_T);
    }
}

