/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc;

import stallone.api.algebra.Algebra;
import stallone.api.algebra.IEigenvalueDecomposition;
import stallone.api.complex.IComplexArray;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.mc.IMarkovPropagator;

public final class TransitionMatrixPropagator
implements IMarkovPropagator {
    private IDoubleArray T;
    private boolean reversible;
    private IDoubleArray R;
    private IDoubleArray L;
    private IDoubleArray evalReal;

    public TransitionMatrixPropagator(IDoubleArray _T) {
        this.set(_T);
    }

    @Override
    public void set(IDoubleArray _P) {
        this.T = _P;
        IEigenvalueDecomposition evd = Algebra.util.evd(_P);
        IComplexArray evComplex = evd.getEval();
        if (evComplex.isReal()) {
            this.evalReal = evComplex;
            this.L = evd.getLeftEigenvectorMatrix();
            this.R = evd.getRightEigenvectorMatrix();
        } else {
            this.reversible = false;
        }
    }

    @Override
    public IDoubleArray propagate(double t) {
        IDoubleArray res = null;
        if (this.reversible) {
            IDoubleArray evalPower = Doubles.create.array(this.evalReal.size());
            int i = 0;
            while (i < evalPower.size()) {
                evalPower.set(i, Math.pow(this.evalReal.get(i), t));
                ++i;
            }
            IDoubleArray D = Doubles.create.diag(evalPower);
            res = Algebra.util.product(this.R, Algebra.util.product(D, this.L));
        } else {
            if ((double)((int)t) - t != 0.0) {
                throw new IllegalArgumentException("Can only use integer times for propagating transition matrices. Attempted t = " + t);
            }
            res = Algebra.util.power(this.T, (int)t);
        }
        return res;
    }
}

