/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.correlations;

import stallone.api.algebra.Algebra;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntList;
import stallone.api.ints.Ints;

public final class MeanFirstPassageTimes {
    IDoubleArray T;
    IIntArray target;
    IDoubleArray mfpts;

    public MeanFirstPassageTimes(IDoubleArray _T, IIntArray _target) {
        this.T = _T;
        this.target = _target;
        this.calculate();
    }

    public static IDoubleArray mfpt(IDoubleArray _T, IIntArray _target) {
        MeanFirstPassageTimes M = new MeanFirstPassageTimes(_T, _target);
        return M.getMfpts();
    }

    public void setT(IDoubleArray _T) {
        this.T = _T;
    }

    public void setTarget(IIntArray _target) {
        this.target = _target;
    }

    public void calculate() {
        int j;
        IDoubleArray A = this.T.copy();
        int i = 0;
        while (i < A.rows()) {
            A.set(i, i, this.T.get(i, i) - 1.0);
            ++i;
        }
        i = 0;
        while (i < this.target.size()) {
            j = 0;
            while (j < A.columns()) {
                A.set(this.target.get(i), j, 0.0);
                ++j;
            }
            A.set(this.target.get(i), this.target.get(i), 1.0);
            ++i;
        }
        IIntList zeros = Ints.create.list(0);
        j = 0;
        while (j < A.columns()) {
            boolean colzero = true;
            int i2 = 0;
            while (i2 < A.rows()) {
                if (A.get(i2, j) != 0.0) {
                    colzero = false;
                }
                ++i2;
            }
            if (colzero) {
                zeros.append(j);
            }
            ++j;
        }
        j = 0;
        while (j < A.columns()) {
            if (!Ints.util.contains(this.target, j) && A.get(j, j) == 0.0) {
                zeros.append(j);
            }
            ++j;
        }
        IIntArray nonzeros = Ints.util.removeValueToNew((IIntArray)Ints.create.listRange(0, A.rows()), zeros);
        IDoubleArray Aclean = A.view(nonzeros.getArray(), nonzeros.getArray());
        IDoubleArray b = Doubles.create.array(A.rows());
        int i3 = 0;
        while (i3 < b.size()) {
            b.set(i3, -1.0);
            ++i3;
        }
        i3 = 0;
        while (i3 < this.target.size()) {
            b.set(this.target.get(i3), 0.0);
            ++i3;
        }
        IDoubleArray bclean = Doubles.util.subToNew(b, nonzeros);
        IDoubleArray X = Algebra.util.solve(Aclean, bclean);
        this.mfpts = Doubles.create.array(this.T.rows(), Double.NaN);
        int i4 = 0;
        while (i4 < nonzeros.size()) {
            this.mfpts.set(nonzeros.get(i4), X.get(i4));
            ++i4;
        }
    }

    public IDoubleArray getMfpts() {
        return this.mfpts;
    }
}

