/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.estimator;

import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleIterator;

public class TransitionMatrixLikelihood {
    public static boolean isFeasible(IDoubleArray T, IDoubleArray C) {
        IDoubleIterator it = C.nonzeroIterator();
        while (it.hasNext()) {
            if (T.get(it.row(), it.column()) == 0.0) {
                return false;
            }
            it.advance();
        }
        return true;
    }

    public static double logLikelihood(IDoubleArray T, IDoubleArray C) {
        double l = 0.0;
        IDoubleIterator it = C.nonzeroIterator();
        while (it.hasNext()) {
            if (T.get(it.row(), it.column()) == 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            int i = it.row();
            int j = it.column();
            l += C.get(i, j) * Math.log(T.get(i, j));
            it.advance();
        }
        return l;
    }

    public static double logLikelihoodCorrelationMatrix(IDoubleArray corr, IDoubleArray C) {
        double l = 0.0;
        double[] pi = new double[corr.rows()];
        int i = 0;
        while (i < pi.length) {
            pi[i] = Doubles.util.sumRow(corr, i);
            ++i;
        }
        IDoubleIterator it = C.nonzeroIterator();
        while (it.hasNext()) {
            if (corr.get(it.row(), it.column()) == 0.0 || pi[it.row()] == 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            int i2 = it.row();
            int j = it.column();
            l += C.get(i2, j) * Math.log(corr.get(i2, j) / pi[i2]);
            it.advance();
        }
        return l;
    }
}

