/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.pcca;

import stallone.api.API;
import stallone.api.algebra.IEigenvalueDecomposition;
import stallone.api.doubles.IDoubleArray;
import stallone.mc.pcca.PCCA;

public class MetastableSubspace {
    private static double MINIMAL_MEMBERSHIP = 1.0E-4;
    private static boolean ENFORCE_REVERSIBILITY = true;
    private IDoubleArray T;
    private IEigenvalueDecomposition evd;
    private IDoubleArray pi = null;
    private IDoubleArray Pi = null;
    private int subspaceSize;
    private PCCA pcca;
    private IDoubleArray M;
    private IDoubleArray piC = null;
    private IDoubleArray PiC;
    private IDoubleArray PObs;
    private IDoubleArray Tcoarse;

    public MetastableSubspace(IDoubleArray _T) {
        this.T = _T;
        this.evd = API.alg.evd(this.T);
        this.pi = API.msm.stationaryDistribution(this.T);
        this.Pi = API.doublesNew.diag(this.pi);
    }

    private void enforceMembershipBounds(IDoubleArray M) {
        int i = 0;
        while (i < M.size()) {
            if (M.get(i) < MINIMAL_MEMBERSHIP) {
                M.set(i, MINIMAL_MEMBERSHIP);
            }
            ++i;
        }
        API.alg.normalizeRows(M, 1);
    }

    private IDoubleArray symmetrize(IDoubleArray C) {
        return API.alg.addWeightedToNew(0.5, C, 0.5, API.alg.transposeToNew(C));
    }

    private void ensureNonnegativeElements(IDoubleArray C) {
        int i = 0;
        while (i < C.rows()) {
            int j = 0;
            while (j < C.columns()) {
                if (C.get(i, j) < 0.0) {
                    C.set(i, j, 0.0);
                }
                ++j;
            }
            ++i;
        }
    }

    public void coarseGrain(int nStates) {
        IDoubleArray Int;
        this.subspaceSize = nStates;
        this.pcca = new PCCA();
        IDoubleArray evec = this.evd.getRightEigenvectorMatrix().viewReal();
        IDoubleArray evecSub = evec.viewBlock(0, 0, this.T.rows(), nStates);
        this.pcca.setEigenvectors(evecSub);
        this.pcca.perform();
        this.M = this.pcca.getFuzzy();
        this.enforceMembershipBounds(this.M);
        this.piC = API.alg.product(API.alg.transposeToNew(this.M), this.pi);
        this.PiC = API.doublesNew.diag(this.piC);
        IDoubleArray Res = API.alg.transposeToNew(this.M);
        this.PObs = Int = API.alg.product(API.alg.product(this.Pi, this.M), API.alg.inverse(this.PiC));
        IDoubleArray RItinv = API.alg.transposeToNew(API.alg.inverse(API.alg.product(Res, Int)));
        IDoubleArray IntT = API.alg.transposeToNew(Int);
        IDoubleArray ResT = API.alg.transposeToNew(Res);
        IDoubleArray TC = API.alg.product(API.alg.product(API.alg.product(RItinv, IntT), this.T), ResT);
        IDoubleArray CC = API.alg.product(this.PiC, TC);
        if (ENFORCE_REVERSIBILITY) {
            CC = this.symmetrize(CC);
        }
        this.ensureNonnegativeElements(CC);
        this.Tcoarse = CC.copy();
        API.alg.normalizeRows(this.Tcoarse, 1);
    }

    public IDoubleArray getMemberships() {
        return this.M;
    }

    public IDoubleArray getObservationProbabilities() {
        return this.PObs;
    }

    public IDoubleArray getCoarseGrainedStationaryDistribution() {
        return this.piC;
    }

    public IDoubleArray getCoarseGrainedTransitionMatrix() {
        return this.Tcoarse;
    }
}

