/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.sampling;

import cern.jet.random.Beta;
import cern.jet.random.Exponential;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import stallone.api.doubles.IDoubleArray;
import stallone.api.mc.IReversibleSamplingStep;
import stallone.mc.sampling.ScaledElementSampler;

public class Step_Rev_Quad_Gibbs_MC
implements IReversibleSamplingStep {
    private int n;
    private IDoubleArray C;
    private IDoubleArray T;
    private IDoubleArray mu;
    private MersenneTwister rand = new MersenneTwister();
    private Uniform randU = new Uniform(0.0, 1.0, this.rand);
    private Exponential randE = new Exponential(1.0, this.rand);
    private Beta randB = new Beta(1.0, 1.0, this.rand);
    double Tnew_ij;
    double Tnew_ji;
    double Tnew_ii;
    double Tnew_jj;
    double r;
    double rprime;
    double pacc;
    int nprop = 0;
    int nacc = 0;

    @Override
    public void init(IDoubleArray _C, IDoubleArray _T, IDoubleArray _mu) {
        this.n = _C.rows();
        this.C = _C;
        this.T = _T;
        this.mu = _mu;
    }

    public void sampleQuad(int i, int j) {
        if (i < j && this.C.get(i, j) + this.C.get(j, i) >= 0.0 && this.C.get(i, i) >= 0.0 && this.C.get(j, j) >= 0.0) {
            double a = this.C.get(i, j) + this.C.get(j, i);
            double delta = this.T.get(i, i) + this.T.get(i, j);
            double lambda = this.mu.get(j) / this.mu.get(i) * (this.T.get(j, j) + this.T.get(j, i));
            if (delta > 1.0E-15 && lambda > 1.0E-15) {
                double d;
                double c;
                double b;
                if (delta <= lambda) {
                    b = this.C.get(i, i);
                    c = this.C.get(j, j);
                    d = lambda / delta;
                } else {
                    b = this.C.get(j, j);
                    c = this.C.get(i, i);
                    d = delta / lambda;
                }
                double x = ScaledElementSampler.sample(this.randU, this.randE, this.randB, a, b, c, d);
                ++this.nprop;
                this.Tnew_ij = x * Math.min(delta, lambda);
                this.Tnew_ii = delta - this.Tnew_ij;
                this.Tnew_ji = this.mu.get(i) / this.mu.get(j) * this.Tnew_ij;
                this.Tnew_jj = this.mu.get(i) / this.mu.get(j) * lambda - this.Tnew_ji;
                this.rprime = Math.sqrt(this.Tnew_ij * this.Tnew_ij + this.Tnew_ji * this.Tnew_ji);
                this.r = Math.sqrt(this.T.get(i, j) * this.T.get(i, j) + this.T.get(j, i) * this.T.get(j, i));
                this.pacc = Math.min(1.0, this.rprime / this.r);
                if (this.randU.nextDouble() <= this.pacc) {
                    this.T.set(i, j, this.Tnew_ij);
                    this.T.set(i, i, this.Tnew_ii);
                    this.T.set(j, i, this.Tnew_ji);
                    this.T.set(j, j, this.Tnew_jj);
                    ++this.nacc;
                }
            }
        }
    }

    @Override
    public boolean step() {
        int k = this.randU.nextIntFromTo(0, this.n - 1);
        int l = this.randU.nextIntFromTo(0, this.n - 1);
        while (k == l) {
            k = this.randU.nextIntFromTo(0, this.n - 1);
            l = this.randU.nextIntFromTo(0, this.n - 1);
        }
        int i = Math.min(k, l);
        int j = Math.max(k, l);
        this.sampleQuad(i, j);
        return true;
    }

    public int[] getStepCount() {
        int[] count = new int[]{this.nprop, this.nacc};
        return count;
    }
}

