/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.sampling;

import stallone.api.doubles.IDoubleArray;
import stallone.api.mc.IReversibleSamplingStep;
import stallone.api.mc.MarkovModel;
import stallone.mc.sampling.Step_Rev_Quad_MC;
import stallone.mc.sampling.Step_Rev_Quad_Trendelkamp;
import stallone.mc.sampling.TransitionMatrixSamplerAbstract;

public class TransitionMatrixSamplerRevFixPi
extends TransitionMatrixSamplerAbstract {
    protected final IDoubleArray piFixed;
    private IReversibleSamplingStep step_quad;

    public TransitionMatrixSamplerRevFixPi(IDoubleArray counts, IDoubleArray piFixed) {
        this.piFixed = piFixed;
        this.init(counts);
    }

    public TransitionMatrixSamplerRevFixPi(IDoubleArray counts, IDoubleArray Tinit, IDoubleArray piFixed) {
        this.piFixed = piFixed;
        this.init(counts, Tinit);
    }

    @Override
    public final void init(IDoubleArray _C, IDoubleArray Tinit) {
        this.C = _C;
        this.T = Tinit == null ? MarkovModel.util.estimateTrev(TransitionMatrixSamplerRevFixPi.eraseNegatives(_C)) : Tinit;
        this.logLikelihood = MarkovModel.util.logLikelihood(this.T, this.C);
        this.step_quad = new Step_Rev_Quad_Trendelkamp();
        this.step_quad.init(this.C, this.T, this.piFixed);
    }

    public static TransitionMatrixSamplerRevFixPi create(IDoubleArray _C, IDoubleArray Tinit, IDoubleArray piFixed, IReversibleSamplingStep _step_quad) {
        TransitionMatrixSamplerRevFixPi res = new TransitionMatrixSamplerRevFixPi(_C, Tinit, piFixed);
        res.step_quad = _step_quad;
        res.step_quad.init(_C, res.T, piFixed);
        return res;
    }

    public static TransitionMatrixSamplerRevFixPi create(IDoubleArray counts, IDoubleArray piFixed, Step_Rev_Quad_MC _step_quad) {
        return TransitionMatrixSamplerRevFixPi.create(counts, null, piFixed, _step_quad);
    }

    @Override
    protected boolean step() {
        return this.step_quad.step();
    }
}

