/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.sampling;

import stallone.api.algebra.Algebra;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;

public class TransitionMatrixSamplingTools {
    public static void ensureValidElement(IDoubleArray T, int i, int j) {
        if (T.get(i, j) < 0.0) {
            T.set(i, j, 0.0);
        }
        if (T.get(i, j) > 1.0) {
            T.set(i, j, 1.0);
        }
    }

    public static boolean isElementIn01(IDoubleArray T, int i, int j) {
        if (T.get(i, j) < 0.0) {
            return false;
        }
        return !(T.get(i, j) > 1.0);
    }

    public static boolean isRowIn01(IDoubleArray T, int i) {
        int j = 0;
        while (j < T.columns()) {
            if (T.get(i, j) < 0.0) {
                return false;
            }
            if (T.get(i, j) > 1.0) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public static double computeDetailedBalanceError(IDoubleArray T, IDoubleArray mu) {
        double err = 0.0;
        int i = 0;
        while (i < T.rows()) {
            int j = 0;
            while (j < T.columns()) {
                err += Math.abs(mu.get(i) * T.get(i, j) - mu.get(j) * T.get(j, i));
                ++j;
            }
            ++i;
        }
        return err;
    }

    public static void ensureValidRow(IDoubleArray T, int i) {
        IDoubleArray r = T.viewRow(i);
        Algebra.util.scale(1.0 / Doubles.util.sum(r), r);
    }
}

