/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.tpt;

import stallone.api.algebra.Algebra;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleIterator;
import stallone.api.ints.IIntArray;
import stallone.api.ints.Ints;
import stallone.api.mc.MarkovModel;
import stallone.api.mc.tpt.ITPTFlux;
import stallone.mc.StationaryDistribution;
import stallone.mc.tpt.Committor;

public class TPTFlux
implements ITPTFlux {
    private IIntArray A;
    private IIntArray B;
    private Committor committor;
    private StationaryDistribution statdist;
    private IDoubleArray P;
    private IDoubleArray pi;
    private IDoubleArray qforward;
    private IDoubleArray qbackward;
    private IDoubleArray flux;
    private IDoubleArray netflux;
    private double totalflux;
    private double kAB;

    public TPTFlux(IDoubleArray M, IIntArray _A, IIntArray _B) {
        this.A = _A;
        this.B = _B;
        this.committor = new Committor(M.rows(), this.A, this.B);
        this.statdist = new StationaryDistribution();
        if (MarkovModel.util.isTransitionMatrix(M)) {
            this.setTransitionMatrix(M);
        } else if (MarkovModel.util.isRateMatrix(M)) {
            this.setRateMatrix(M);
        } else {
            throw new IllegalArgumentException("Trying to construct TPT with a matrix that is neither a transition nor a rate matrix");
        }
    }

    @Override
    public final void setTransitionMatrix(IDoubleArray _T) {
        this.P = _T;
        this.committor.setTransitionMatrix(_T);
        this.statdist.setT(_T);
    }

    @Override
    public final void setRateMatrix(IDoubleArray _K) {
        this.P = _K;
        this.committor.setRateMatrix(_K);
        this.statdist.setK(_K);
    }

    @Override
    public void setStationaryDistribution(IDoubleArray _pi) {
        this.pi = Doubles.create.array(_pi.getArray());
    }

    @Override
    public void calculate() {
        int j;
        int i;
        if (this.pi == null) {
            this.pi = this.statdist.calculate();
        }
        this.qbackward = this.committor.backwardCommittor();
        this.qforward = this.committor.forwardCommittor();
        this.flux = this.P.create(this.P.rows(), this.P.columns());
        IDoubleIterator it = this.P.nonzeroIterator();
        while (it.hasNext()) {
            i = it.row();
            j = it.column();
            if (!Ints.util.contains(this.B, i) && !Ints.util.contains(this.A, j)) {
                this.flux.set(i, j, this.pi.get(i) * this.qbackward.get(i) * this.P.get(i, j) * this.qforward.get(j));
            }
            it.advance();
        }
        this.netflux = this.P.create(this.P.rows(), this.P.columns());
        it = this.P.nonzeroIterator();
        while (it.hasNext()) {
            i = it.row();
            if (this.flux.get(i, j = it.column()) > this.flux.get(j, i)) {
                this.netflux.set(i, j, this.flux.get(i, j) - this.flux.get(j, i));
            }
            it.advance();
        }
        this.totalflux = 0.0;
        int i2 = 0;
        while (i2 < this.A.size()) {
            this.totalflux += Doubles.util.sum(this.flux.viewRow(i2));
            ++i2;
        }
        this.kAB = this.totalflux / Doubles.util.sum(Algebra.util.multiplyElementsToNew(this.pi, this.qbackward));
    }

    @Override
    public IDoubleArray getStationaryDistribution() {
        return this.pi;
    }

    @Override
    public IDoubleArray getBackwardCommittor() {
        return this.qbackward;
    }

    @Override
    public IDoubleArray getForwardCommittor() {
        return this.qforward;
    }

    @Override
    public IDoubleArray getFlux() {
        return this.flux;
    }

    @Override
    public IDoubleArray getNetFlux() {
        return this.netflux;
    }

    @Override
    public double getTotalFlux() {
        return this.totalflux;
    }

    @Override
    public double getRate() {
        return this.kAB;
    }
}

