/*
 * Decompiled with CFR 0.152.
 */
package stallone.potential;

import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.potential.AbstractPotential;

public class BistablePotential
extends AbstractPotential {
    private IDoubleArray gradArr = Doubles.create.array(1);
    private IDoubleArray dArr = Doubles.create.array(1);
    private double k2;
    private double k4;
    private double d0;
    private double d;
    private double grad;
    private double energy;

    public BistablePotential(double _k2, double _k4, double _d0) {
        this.k2 = _k2;
        this.k4 = _k4;
        this.d0 = _d0;
    }

    @Override
    public void setCoordinates(IDoubleArray coordinates) {
        this.d = coordinates.get(0);
    }

    @Override
    public boolean calculate() {
        double g0;
        double dd1 = this.d - this.d0;
        double dd2 = dd1 * dd1;
        double dd3 = dd1 * dd2;
        double dd4 = dd2 * dd2;
        this.energy = -this.k2 * dd2 / 2.0 + this.k4 * dd4 / 4.0;
        this.grad = g0 = -this.k2 * dd1 + this.k4 * dd3;
        return true;
    }

    @Override
    public int getNDimensions() {
        return 1;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public IDoubleArray getGradient() {
        this.gradArr.set(0, this.grad);
        return this.gradArr;
    }

    @Override
    public IDoubleArray getCoordinates() {
        this.dArr.set(0, this.d);
        return this.dArr;
    }

    @Override
    public int getNumberOfVariables() {
        return 1;
    }
}

