/*
 * Decompiled with CFR 0.152.
 */
package stallone.potential;

import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDifferentiableMetric;
import stallone.api.doubles.IDoubleArray;
import stallone.api.ints.IIntArray;
import stallone.potential.AbstractPotential;

public class LennardJonesSystem
extends AbstractPotential {
    private IDoubleArray coordinates;
    private IDifferentiableMetric<IDoubleArray> metric;
    private int natoms = 0;
    private boolean[][] bonded;
    private IDoubleArray r;
    private IDoubleArray eps;
    private double energy;
    private IDoubleArray gradient;

    public LennardJonesSystem(int _natoms, IDoubleArray radii, IDoubleArray epsilons) {
        this.natoms = _natoms;
        this.r = radii;
        this.eps = epsilons;
        this.bonded = new boolean[_natoms][_natoms];
        this.coordinates = Doubles.create.array(_natoms, 3);
        this.gradient = Doubles.create.array(_natoms, 3);
    }

    public LennardJonesSystem(int _natoms, IDoubleArray radii, IDoubleArray epsilons, boolean[][] _bonded) {
        this.natoms = _natoms;
        this.r = radii;
        this.eps = epsilons;
        this.bonded = _bonded;
        this.coordinates = Doubles.create.array(_natoms, 3);
        this.gradient = Doubles.create.array(_natoms, 3);
    }

    public LennardJonesSystem(int _natoms, IDoubleArray radii, IDoubleArray epsilons, IIntArray _bonded) {
        this.natoms = _natoms;
        this.r = radii;
        this.eps = epsilons;
        this.bonded = new boolean[_natoms][_natoms];
        int i = 0;
        while (i < _bonded.rows()) {
            this.bonded[_bonded.get((int)i, (int)0)][_bonded.get((int)i, (int)1)] = true;
            ++i;
        }
        this.coordinates = Doubles.create.array(_natoms, 3);
        this.gradient = Doubles.create.array(_natoms, 3);
    }

    public void setMetric(IDifferentiableMetric<IDoubleArray> m) {
        this.metric = m;
    }

    @Override
    public void setCoordinates(IDoubleArray _coordinates) {
        this.coordinates.copyFrom(_coordinates);
    }

    @Override
    public boolean calculate() {
        this.energy = 0.0;
        int i = 0;
        while (i < this.gradient.size()) {
            this.gradient.set(i, 0.0);
            ++i;
        }
        i = 0;
        while (i < this.natoms - 1) {
            int j = i + 1;
            while (j < this.natoms) {
                if (!this.bonded[i][j]) {
                    IDoubleArray c1 = this.coordinates.viewRow(i);
                    IDoubleArray c2 = this.coordinates.viewRow(j);
                    double d = this.metric.distance(c1, c2);
                    double eps2 = 2.0 * this.eps.get(i) * this.eps.get(j) / (this.eps.get(i) + this.eps.get(j));
                    double r2 = 2.0 * Math.sqrt(this.r.get(i) * this.r.get(j));
                    double r2d = r2 / d;
                    double e = 4.0 * eps2 * (Math.pow(r2d, 12.0) - Math.pow(r2d, 6.0));
                    this.energy += e;
                    System.out.println(" vdw [" + i + "," + j + "]\t" + e + "\t at d = " + d + " \t with eps = " + eps2 + "\t r = " + r2);
                    double fm = 4.0 * eps2 * (6.0 * Math.pow(r2d, 6.0) / d - 12.0 * Math.pow(r2d, 12.0) / d);
                    IDoubleArray mg1 = this.metric.gradientX(c1, c2);
                    int dim = 0;
                    while (dim < 3) {
                        this.gradient.set(i, dim, this.gradient.get(i, dim) + fm * mg1.get(dim));
                        ++dim;
                    }
                    IDoubleArray mg2 = this.metric.gradientY(c1, c2);
                    int dim2 = 0;
                    while (dim2 < 3) {
                        this.gradient.set(j, dim2, this.gradient.get(j, dim2) + fm * mg2.get(dim2));
                        ++dim2;
                    }
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int getNDimensions() {
        return this.natoms * 3;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public IDoubleArray getGradient() {
        return this.gradient;
    }

    @Override
    public IDoubleArray getCoordinates() {
        return this.coordinates;
    }

    @Override
    public int getNumberOfVariables() {
        return this.coordinates.size();
    }
}

