/*
 * Decompiled with CFR 0.152.
 */
package stallone.stat;

public class RunningAverage {
    private double mean = 0.0;
    private double variance = 0.0;
    private int n = 0;

    public void add(double x) {
        double newmean = this.mean + (x - this.mean) / (double)(this.n + 1);
        double newvar = 0.0;
        if (this.n > 0) {
            newvar = ((double)(this.n - 1) * this.variance + (x - newmean) * (x - this.mean)) / (double)this.n;
        }
        this.mean = newmean;
        this.variance = newvar;
        ++this.n;
    }

    public double getMean() {
        return this.mean;
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.variance);
    }

    public double getVariance() {
        return this.variance;
    }

    public int getN() {
        return this.n;
    }
}

