/*
 * Decompiled with CFR 0.152.
 */
package stallone.stat;

import java.util.Arrays;
import java.util.List;
import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleList;
import stallone.util.CommandLineParser;

public class SmoothedCorrelator {
    private IDoubleArray lagtimes;
    private IDoubleArray averageWidths;
    private IDoubleArray correlation;
    private IDoubleArray weights;
    private double sum = 0.0;
    private double sumOfWeights = 0.0;

    public SmoothedCorrelator(IDoubleArray _lagtimes, IDoubleArray _averageWidths) {
        if (_lagtimes.size() != _averageWidths.size()) {
            throw new IllegalArgumentException("Number of lagtimes does not match number of average widths in correlate.");
        }
        this.lagtimes = _lagtimes;
        this.averageWidths = _averageWidths;
        this.correlation = API.doublesNew.array(this.lagtimes.size());
        this.weights = API.doublesNew.array(this.lagtimes.size());
    }

    public static String getUsageString() {
        String res = "EventCorrelator\nCorrelates the given columns of all files passed.-i <trajectorie(s)>\n\n-columns <time> <D> <A>\n-maxtime <maxy>\n-subtractmean\n";
        return res;
    }

    public static CommandLineParser parseArguments(String[] args) {
        CommandLineParser parser = new CommandLineParser();
        parser.addStringArrayCommand("i", true);
        parser.addCommand("columns", true);
        parser.addIntArgument("columns", true);
        parser.addIntArgument("columns", true);
        parser.addIntArgument("columns", true);
        parser.addIntCommand("maxtime", true);
        parser.addCommand("subtractmean", true);
        if (!parser.parse(args)) {
            throw new IllegalArgumentException("Parsing error!");
        }
        return parser;
    }

    private static IDoubleArray cumulate(IDoubleArray data) {
        IDoubleArray res = API.doublesNew.array(data.size() + 1);
        res.set(0, 0.0);
        int i = 1;
        while (i < res.size()) {
            res.set(i, res.get(i - 1) + data.get(i - 1));
            ++i;
        }
        return res;
    }

    public static double correlate(IDoubleArray time, IDoubleArray data, double tau, double averageWidth) {
        if (time.size() != data.size()) {
            throw new IllegalArgumentException("Number of time points does not match number of data points in correlate.");
        }
        int i1 = 0;
        int i2 = 0;
        int j1 = 0;
        int j2 = 0;
        double sum = 0.0;
        double count = 0.0;
        IDoubleArray cumdata = SmoothedCorrelator.cumulate(data);
        double maxtime = time.get(time.size() - 1);
        while (maxtime - time.get(i1) >= tau) {
            i2 = i1;
            while (time.get(i2) - time.get(i1) <= averageWidth && i2 < time.size()) {
                if (++i2 >= time.size()) break;
            }
            while (time.get(j1) - time.get(i1) < tau && maxtime - time.get(j1) >= tau) {
                if (++j1 >= time.size()) break;
            }
            if ((j2 = j1) < time.size()) {
                while (time.get(j2) - time.get(j1) <= averageWidth && j2 < time.size()) {
                    if (++j2 >= time.size()) break;
                }
            }
            double x1 = (cumdata.get(i2) - cumdata.get(i1)) / (double)(i2 - i1);
            double x2 = (cumdata.get(j2) - cumdata.get(j1)) / (double)(j2 - j1);
            sum += x1 * x2;
            count += 1.0;
            if (++i1 >= time.size()) break;
        }
        return sum / count;
    }

    public IDoubleArray correlate(IDoubleArray time, IDoubleArray data) {
        IDoubleArray res = API.doublesNew.array(this.lagtimes.size());
        int i = 0;
        while (i < res.size()) {
            res.set(i, SmoothedCorrelator.correlate(time, data, this.lagtimes.get(i), this.averageWidths.get(i)));
            ++i;
        }
        return res;
    }

    public void add(IDoubleArray time, IDoubleArray data) {
        IDoubleArray c = this.correlate(time, data);
        int i = 0;
        while (i < c.size()) {
            if (!Double.isNaN(c.get(i))) {
                this.correlation.set(i, this.correlation.get(i) + (double)data.size() * c.get(i));
                this.weights.set(i, this.weights.get(i) + (double)data.size());
            }
            ++i;
        }
        this.sum += API.doubles.sum(data);
        this.sumOfWeights += (double)time.size();
    }

    public IDoubleArray getCorrelation() {
        IDoubleArray res = API.doublesNew.array(this.correlation.size());
        int i = 0;
        while (i < res.size()) {
            res.set(i, this.correlation.get(i) / this.weights.get(i));
            ++i;
        }
        return res;
    }

    public IDoubleArray getCorrelationMeanFree() {
        IDoubleArray res = API.doublesNew.array(this.correlation.size());
        double shift = this.sum / this.sumOfWeights * (this.sum / this.sumOfWeights);
        int i = 0;
        while (i < res.size()) {
            res.set(i, this.correlation.get(i) / this.weights.get(i) - shift);
            ++i;
        }
        return res;
    }

    public void reset() {
        this.correlation.zero();
        this.weights.zero();
        this.sum = 0.0;
        this.sumOfWeights = 0.0;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(SmoothedCorrelator.getUsageString());
            System.exit(0);
        }
        CommandLineParser parser = SmoothedCorrelator.parseArguments(args);
        List<String> inputFiles = Arrays.asList(parser.getStringArray("i"));
        int timecol = parser.getInt("columns", 0);
        int col1 = parser.getInt("columns", 1);
        int col2 = parser.getInt("columns", 2);
        int maxtime = parser.getInt("maxtime", 0);
        boolean subtractMean = parser.hasCommand("subtractmean");
        IDoubleList lagtimes = API.doublesNew.listFrom(0.0, 1.0);
        while (lagtimes.get(lagtimes.size() - 1) < (double)maxtime) {
            lagtimes.append((int)((lagtimes.get(lagtimes.size() - 1) + 1.0) * 1.1));
        }
        IDoubleArray averageWidths = API.doublesNew.array(lagtimes.size());
        int i = 0;
        while (i < averageWidths.size()) {
            averageWidths.set(i, 0.1 * lagtimes.get(i));
            ++i;
        }
        SmoothedCorrelator correlator = new SmoothedCorrelator(lagtimes, averageWidths);
        int i2 = 0;
        while (i2 < inputFiles.size()) {
            IDoubleArray time = API.data.readColumn(inputFiles.get(i2), timecol);
            IDoubleArray don = API.data.readColumn(inputFiles.get(i2), col1);
            IDoubleArray acc = API.data.readColumn(inputFiles.get(i2), col2);
            IDoubleArray E = API.doublesNew.array(don.size());
            int j = 0;
            while (j < E.size()) {
                E.set(j, acc.get(j) / (don.get(j) + acc.get(j)));
                ++j;
            }
            correlator.add(time, E);
            ++i2;
        }
        IDoubleArray corr = null;
        corr = subtractMean ? correlator.getCorrelationMeanFree() : correlator.getCorrelation();
        int i3 = 0;
        while (i3 < lagtimes.size()) {
            System.out.println(String.valueOf(lagtimes.get(i3)) + "\t" + corr.get(i3));
            ++i3;
        }
    }
}

