/*
 * Decompiled with CFR 0.152.
 */
package stallone.stat.modelselection;

import stallone.doubles.PrimitiveDoubleTools;
import stallone.ints.PrimitiveIntTools;
import stallone.stat.modelselection.ExitTimes;

public class Splitter {
    private double[] exitTimes;
    private ExitTimes et;

    public Splitter(double[] _exitTimes, int _nburnin, int _nsample) {
        this.exitTimes = _exitTimes;
        this.et = new ExitTimes(_exitTimes);
        this.et.run(_nburnin, _nsample);
    }

    public Splitter(double[] _exitTimes) {
        this.exitTimes = _exitTimes;
        this.et = new ExitTimes(_exitTimes);
        this.et.run(1000, 10000);
    }

    public boolean split() {
        return this.et.getNumberOfStates() > 1.5;
    }

    public int[] getAssignment() {
        int[] res = new int[this.exitTimes.length];
        if (this.et.getNumberOfStates() <= 1.5) {
            return res;
        }
        double[] par = this.et.getMeanK2();
        double a = par[0];
        double k1 = par[1];
        double k2 = par[2];
        int i = 0;
        while (i < res.length) {
            res[i] = a * k1 * Math.exp(-k1 * this.exitTimes[i]) < (1.0 - a) * k2 * Math.exp(-k2 * this.exitTimes[i]) ? 0 : 1;
            ++i;
        }
        return res;
    }

    public double[][] getExitTimes() {
        if (this.split()) {
            int[] assign = this.getAssignment();
            int[] I0 = PrimitiveIntTools.findAll(assign, 0);
            int[] I1 = PrimitiveIntTools.findAll(assign, 1);
            double[] times1 = PrimitiveDoubleTools.subarray(this.exitTimes, I0);
            double[] times2 = PrimitiveDoubleTools.subarray(this.exitTimes, I1);
            return new double[][]{times1, times2};
        }
        return new double[][]{this.exitTimes};
    }
}

