/*
 * Decompiled with CFR 0.152.
 */
package stallone.ui;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.api.ints.IIntArray;
import stallone.ints.PrimitiveIntTools;
import stallone.util.Arguments;

public class MSM_Connectivity {
    public static void main(String[] args) throws FileNotFoundException, IOException {
        if (args.length == 0) {
            System.out.println("MSM_Connectivity -iC <count-matrix> [-oGiant <file>]");
            System.out.println();
            System.out.println("Calculates the connectivity (strong components) of the specified count matrix. -oGiant writes out the giant component");
            System.exit(0);
        }
        Arguments arg = new Arguments(args);
        IDoubleArray C = API.doublesNew.fromFile(arg.getArgument("iC"));
        List<IIntArray> components = API.graph.connectedComponents(C);
        int[] I = PrimitiveIntTools.sortedIndexes(API.intseq.lengths(components));
        System.out.println("Strong Components: " + I.length);
        System.out.println("Lengths: " + PrimitiveIntTools.toString(I, ", "));
        System.out.println("members: ");
        int i = 0;
        while (i < I.length) {
            IIntArray c = components.get(I[i]);
            System.out.println(String.valueOf(API.ints.toString(c)) + " ");
            ++i;
        }
        if (arg.hasCommand("oGiant")) {
            API.io.writeString(arg.getArgument("oGiant"), API.ints.toString(components.get(I[0]), "\n"));
        }
    }
}

