/*
 * Decompiled with CFR 0.152.
 */
package stallone.ui;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.ints.PrimitiveIntTools;
import stallone.mc.tpt.PathwayDecomposition;
import stallone.util.Arguments;

public class MSM_Flux {
    public static void main(String[] args) throws FileNotFoundException, IOException {
        Arguments arg;
        if (args.length == 0) {
            System.out.println("MSM_Flux -cg -i <flux> <sets> -oflux <file> -onetflux <file>");
            System.out.println("Coarse-grains TPT fluxes");
            System.out.println();
            System.out.println("MSM_Flux -pathways <flux> <q+> <A> <B>");
            System.out.println("Pathway decomposition");
            System.exit(0);
        }
        if ((arg = new Arguments(args)).hasCommand("cg")) {
            IDoubleArray f = API.doublesNew.fromFile(arg.getArgument("i", 0));
            int[][] I = API.io.readIntMatrix(arg.getArgument("i", 1));
            IDoubleArray F = API.doublesNew.matrix(I.length, I.length);
            int I1 = 0;
            while (I1 < I.length) {
                int I2 = 0;
                while (I2 < I.length) {
                    int i = 0;
                    while (i < I[I1].length) {
                        int j = 0;
                        while (j < I[I2].length) {
                            F.set(I1, I2, F.get(I1, I2) + f.get(I[I1][i], I[I2][j]));
                            ++j;
                        }
                        ++i;
                    }
                    ++I2;
                }
                ++I1;
            }
            IDoubleArray Fnet = API.doublesNew.matrix(I.length, I.length);
            int i = 0;
            while (i < Fnet.rows()) {
                Fnet.set(i, i, 0.0);
                int j = i + 1;
                while (j < Fnet.columns()) {
                    if (F.get(i, j) > F.get(j, i)) {
                        Fnet.set(i, j, F.get(i, j) - F.get(j, i));
                    } else {
                        Fnet.set(j, i, F.get(j, i) - F.get(i, j));
                    }
                    ++j;
                }
                ++i;
            }
            if (arg.hasCommand("oflux")) {
                API.doubles.writeMatrixSparse(F, new PrintStream(arg.getArgument("oflux")));
            }
            if (arg.hasCommand("onetflux")) {
                API.doubles.writeMatrixSparse(Fnet, new PrintStream(arg.getArgument("onetflux")));
            }
        }
        if (arg.hasCommand("pathways")) {
            IDoubleArray F = API.doublesNew.fromFile(arg.getArgument("pathways", 0));
            double[] Q = API.io.readDoubleColumn(arg.getArgument("pathways", 1), 0);
            int[] A = API.str.toIntArray(arg.getArgument("pathways", 2));
            int[] B = API.str.toIntArray(arg.getArgument("pathways", 3));
            PathwayDecomposition decomp = new PathwayDecomposition(F, Q, A, B);
            ArrayList<int[]> allPaths = new ArrayList<int[]>();
            ArrayList<Double> allFluxes = new ArrayList<Double>();
            int[] path = null;
            double totalFlux = 0.0;
            do {
                if ((path = decomp.nextPathway()) == null) continue;
                allPaths.add(path);
                allFluxes.add(decomp.getCurrentFlux().doubleValue());
                totalFlux += decomp.getCurrentFlux().doubleValue();
            } while (path != null);
            System.out.println("path\tflux\tcum. flux\tcum. fraction");
            double cumulativeFlux = 0.0;
            int i = 0;
            while (i < allPaths.size()) {
                System.out.print(PrimitiveIntTools.toString((int[])allPaths.get(i)));
                System.out.print("\t");
                System.out.print(allFluxes.get(i));
                System.out.print("\t");
                System.out.print(cumulativeFlux += ((Double)allFluxes.get(i)).doubleValue());
                System.out.print("\t");
                System.out.print(cumulativeFlux / totalFlux);
                System.out.println();
                ++i;
            }
        }
    }
}

