/*
 * Decompiled with CFR 0.152.
 */
package stallone.ui;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.api.hmm.IHMM;
import stallone.api.hmm.ParameterEstimationException;
import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntList;
import stallone.util.CommandLineParser;

public class NinjaEstimatorCmd {
    private List<String> inputFiles;
    private List<IIntArray> discreteTrajectories;
    private int nhidden;
    private IDoubleArray init_T = null;
    private IDoubleArray init_Chi = null;
    private boolean singlePointEstimate = false;
    private int tau = 1;
    private int timeshift = 1;
    private boolean multiStartEstimate = false;
    private double[] metastabilities;
    private boolean hmmTimescalesEstimate = false;
    private int taumin = 1;
    private int taumax = 1000;
    private double taumult = 1.2;
    private int maxAverageWindow = 10;
    private double hmmDecTol = 0.0;
    private int hmmNIter = 1000;
    private boolean direct = false;
    private String outdir;

    public boolean parseArguments(String[] args) throws FileNotFoundException, IOException {
        CommandLineParser parser = new CommandLineParser();
        parser.addStringArrayCommand("i", true);
        parser.addIntCommand("nhidden", true);
        parser.addCommand("init", false);
        parser.addStringArgument("init", true);
        parser.addStringArgument("init", true);
        parser.addCommand("estimate", false);
        parser.addIntArgument("estimate", true);
        parser.addIntArgument("estimate", true);
        parser.addCommand("hmmtimescales", false);
        parser.addIntArgument("hmmtimescales", true);
        parser.addIntArgument("hmmtimescales", true);
        parser.addDoubleArgument("hmmtimescales", true);
        parser.addIntArgument("hmmtimescales", true);
        parser.addCommand("hmmconv", false);
        parser.addDoubleArgument("hmmconv", true, -0.1, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        parser.addIntArgument("hmmconv", true, 1000, 0, Integer.MAX_VALUE);
        parser.addCommand("direct", false);
        parser.addStringCommand("o", true);
        if (!parser.parse(args)) {
            return false;
        }
        String[] ifiles = parser.getStringArray("i");
        this.inputFiles = new ArrayList<String>();
        int i = 0;
        while (i < ifiles.length) {
            this.inputFiles.add(ifiles[i]);
            ++i;
        }
        this.discreteTrajectories = API.intseqNew.intSequenceLoader(this.inputFiles).loadAll();
        this.nhidden = parser.getInt("nhidden");
        if (parser.hasCommand("init")) {
            String fileT = parser.getString("init", 0);
            this.init_T = API.doublesNew.fromFile(fileT);
            String fileChi = parser.getString("init", 1);
            this.init_Chi = API.doublesNew.fromFile(fileChi);
        }
        if (parser.hasCommand("estimate")) {
            this.singlePointEstimate = true;
            this.tau = parser.getInt("estimate", 0);
            this.timeshift = parser.getInt("estimate", 1);
        } else if (parser.hasCommand("estimatemult")) {
            this.multiStartEstimate = true;
            this.tau = parser.getInt("estimatemult", 0);
            this.timeshift = parser.getInt("estimatemult", 1);
            this.metastabilities = parser.getDoubleArray("metastabilities");
        } else if (parser.hasCommand("hmmtimescales")) {
            this.hmmTimescalesEstimate = true;
            this.taumin = parser.getInt("hmmtimescales", 0);
            this.taumax = parser.getInt("hmmtimescales", 1);
            this.taumult = parser.getDouble("hmmtimescales", 2);
            this.timeshift = parser.getInt("hmmtimescales", 3);
        }
        this.direct = parser.hasCommand("direct");
        if (parser.hasCommand("hmmconv")) {
            this.hmmDecTol = parser.getDouble("hmmconv", 0);
            this.hmmNIter = parser.getInt("hmmconv", 1);
        }
        this.outdir = parser.getString("o");
        return true;
    }

    public static String getUsageString() {
        return "\n=======================================\n NinjaEstimator\n=======================================\nUsage: \n\nMandatory input and output options: \n -i <discrete trajectory>+\n -nhidden <number of hidden states>\n\n -o <out-dir>\n\nAny of: \n -estimate <lag time> <average-window>\n\n [-init <T-init> <chi-init>]\n -hmmtimescales <min-lag> <max-lag> <lag-mult> <timeshift>\n [-direct]\n  enforce direct estimate at each lagtime rather than using the previous result to initialize the next lagtime\n [-hmmconv <decrease-tolerance> <niter>]\n  hmm convergence options\n\n";
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, ParameterEstimationException {
        NinjaEstimatorCmd cmd;
        if (args.length == 0) {
            System.out.println(NinjaEstimatorCmd.getUsageString());
            System.exit(0);
        }
        if (!(cmd = new NinjaEstimatorCmd()).parseArguments(args)) {
            System.out.println(NinjaEstimatorCmd.getUsageString());
            System.exit(0);
        }
        if (cmd.singlePointEstimate) {
            IHMM pmm = API.hmm.pmm(cmd.discreteTrajectories, cmd.nhidden, cmd.tau, cmd.timeshift, cmd.hmmNIter, cmd.hmmDecTol, null, null);
            IDoubleArray hmmTC = pmm.getTransitionMatrix();
            API.io.writeString(String.valueOf(cmd.outdir) + "/hmmTc.dat", API.doubles.toString(hmmTC, "\t", "\n"));
            IDoubleArray hmmChi = pmm.getOutputParameters();
            API.io.writeString(String.valueOf(cmd.outdir) + "/hmmChi.dat", API.doubles.toString(hmmChi, "\t", "\n"));
        } else if (cmd.hmmTimescalesEstimate) {
            IIntList lagtimes = API.intsNew.list(0);
            lagtimes.append(cmd.taumin);
            double tau = cmd.taumin;
            while (tau <= (double)cmd.taumax) {
                int lag = (int)tau;
                if (lag != lagtimes.get(lagtimes.size() - 1)) {
                    lagtimes.append(lag);
                }
                tau *= cmd.taumult;
            }
            PrintStream itsout = new PrintStream(String.valueOf(cmd.outdir) + "/hmm-its.dat");
            IDoubleArray lastTC = cmd.init_T;
            IDoubleArray lastChi = cmd.init_Chi;
            int i = 0;
            while (i < lagtimes.size()) {
                int lag = lagtimes.get(i);
                System.out.println("\ntau = " + lag + "\n");
                if (cmd.direct) {
                    lastTC = null;
                    lastChi = null;
                }
                System.out.println("Hidden state: " + cmd.nhidden);
                IHMM pmm = API.hmm.pmm(cmd.discreteTrajectories, cmd.nhidden, lag, cmd.timeshift, cmd.hmmNIter, cmd.hmmDecTol, lastTC, lastChi);
                lastTC = pmm.getTransitionMatrix();
                lastChi = pmm.getOutputParameters();
                double lastLogL = pmm.getLogLikelihood();
                IDoubleArray hmmTimescales = API.msm.timescales(lastTC, lag);
                itsout.println(String.valueOf(lag) + "\t" + lastLogL + "\t" + API.doubles.toString(hmmTimescales, "", " "));
                PrintStream TCout = new PrintStream(String.valueOf(cmd.outdir) + "/hmm-TC-lag" + lag + ".dat");
                TCout.print(API.doubles.toString(lastTC, "\t", "\n"));
                TCout.close();
                PrintStream Chiout = new PrintStream(String.valueOf(cmd.outdir) + "/hmm-Chi-lag" + lag + ".dat");
                Chiout.print(API.doubles.toString(lastChi, "\t", "\n"));
                Chiout.close();
                ++i;
            }
            itsout.close();
        }
    }
}

