/*
 * Decompiled with CFR 0.152.
 */
package stallone.util;

import stallone.util.Arguments;
import stallone.util.ExpectedArgument;
import stallone.util.StringTools;

class DoubleArgument
extends ExpectedArgument {
    double minValue;
    double maxValue;
    double value;

    public DoubleArgument(String cmd, int pos, boolean _mandatory, double _defaultValue, double _minValue, double _maxValue) {
        super(cmd, pos, _mandatory);
        this.value = _defaultValue;
        this.minValue = _minValue;
        this.maxValue = _maxValue;
        if (!(this.mandatory || this.minValue <= this.value && this.value <= this.maxValue)) {
            throw new IllegalArgumentException("Default value " + _defaultValue + " of double argument " + cmd + " " + pos + " is out of range [" + _minValue + "," + _maxValue + "]");
        }
    }

    @Override
    public boolean parseWhenAvailable(Arguments args) {
        String argFound = args.getArgument(this.command, this.position);
        if (!StringTools.isDouble(argFound)) {
            System.out.println("Command -" + this.command + " has unexpected argument: " + argFound + ". Expect a double value");
        }
        this.value = StringTools.toDouble(argFound);
        if (!(this.minValue <= this.value) || !(this.value <= this.maxValue)) {
            System.out.println("Command -" + this.command + " has unexpected argument value: " + this.value + ". Expecting a double in the range [" + this.minValue + "," + this.maxValue + "]");
        }
        return true;
    }

    public double getValue() {
        return this.value;
    }
}

