/*
 * Decompiled with CFR 0.152.
 */
package stallone.util;

public class MathTools {
    public static double acos(double arg) {
        if (arg < 0.0) {
            return Math.PI - Math.atan(Math.sqrt(1.0 / (arg * arg) - 1.0));
        }
        return Math.atan(Math.sqrt(1.0 / (arg * arg) - 1.0));
    }

    public static int sign(double f) {
        if (f > 0.0) {
            return 1;
        }
        if (f < 0.0) {
            return -1;
        }
        return 0;
    }

    public static double bound(double number, double lbound, double ubound) {
        if (number < lbound) {
            return lbound;
        }
        if (number > ubound) {
            return ubound;
        }
        return number;
    }

    public static double randomDouble(double l, double u) {
        if (u <= l) {
            throw new IllegalArgumentException("Exit in randomDouble: u must be larger than l");
        }
        return l + (u - l) * Math.random();
    }

    public static int randomInt(int l, int u) {
        if (u <= l) {
            throw new RuntimeException("Exit in randomInt: u must be larger than l");
        }
        return (int)((double)l + (double)(u - l) * Math.random());
    }

    public static int randomSign() {
        if (Math.random() < 0.5) {
            return -1;
        }
        return 1;
    }

    public static double min(double m1, double m2, double m3) {
        if (m1 <= m2 && m1 <= m3) {
            return m1;
        }
        if (m2 <= m1 && m2 <= m3) {
            return m2;
        }
        return m3;
    }

    public static double min(double m1, double m2, double m3, double m4) {
        return Math.min(m1, MathTools.min(m2, m3, m4));
    }

    public static double max(double m1, double m2, double m3) {
        if (m1 >= m2 && m1 >= m3) {
            return m1;
        }
        if (m2 >= m1 && m2 >= m3) {
            return m2;
        }
        return m3;
    }

    public static double max(double m1, double m2, double m3, double m4) {
        return Math.max(m1, MathTools.max(m2, m3, m4));
    }

    public static double degreeMod(double angle) {
        if (angle < -180.0) {
            return angle + 360.0;
        }
        if (angle > 180.0) {
            return angle - 360.0;
        }
        return angle;
    }

    public static double degreeDiff(double angle1, double angle2) {
        return MathTools.degreeMod(angle2 - angle1);
    }

    public static double degreeAvg(double angle1, double angle2) {
        return MathTools.degreeMod(angle1 + 0.5 * MathTools.degreeDiff(angle1, angle2));
    }

    public static double degreeAvg(double[] angles) {
        double[] rangles = new double[angles.length];
        int i = 0;
        while (i < rangles.length) {
            rangles[i] = Math.PI * angles[i] / 180.0;
            ++i;
        }
        return 180.0 * MathTools.radAvg(rangles) / Math.PI;
    }

    public static double radMod(double angle) {
        if (angle < -Math.PI) {
            return angle + Math.PI * 2;
        }
        if (angle > Math.PI) {
            return angle - Math.PI * 2;
        }
        return angle;
    }

    public static double radDiff(double angle1, double angle2) {
        return MathTools.radMod(angle2 - angle1);
    }

    public static double radAvg(double angle1, double angle2) {
        return MathTools.radMod(angle1 + MathTools.radDiff(angle1, angle2));
    }

    public static double radAvg(double[] angles) {
        double nom = 0.0;
        double dnom = 0.0;
        int i = 0;
        while (i < angles.length) {
            nom += Math.sin(angles[i]);
            dnom += Math.cos(angles[i]);
            ++i;
        }
        return Math.atan2(nom, dnom);
    }

    public static double ceilTo(double value, double power) {
        double fac = Math.pow(10.0, power);
        return fac * Math.ceil(value / fac);
    }

    public static double floorTo(double value, double power) {
        double fac = Math.pow(10.0, power);
        return fac * Math.floor(value / fac);
    }

    public static double factorial(int n) {
        if (n > 170) {
            throw new RuntimeException("Can't compute factorial(n) for n>170");
        }
        double f = 1.0;
        int i = n;
        while (i > 1) {
            f *= (double)i;
            --i;
        }
        return f;
    }

    public static double doubleFactorial(int n) {
        if (n > 300) {
            throw new RuntimeException("Can't compute doubleFactorial(n) for n>300");
        }
        double f = 1.0;
        int i = n;
        while (i > 1) {
            f *= (double)i;
            i -= 2;
        }
        return f;
    }

    public static double hyperSphereSurfaceArea(int n, double R) {
        int k = MathTools.isEven(n) ? n / 2 : (n - 1) / 2;
        double S = Math.pow(2.0, n - k) * Math.pow(Math.PI, k) * Math.pow(R, n - 1) * (double)n / MathTools.doubleFactorial(n);
        return S;
    }

    public static double hyperSphereVolume(int n, double R) {
        double S = MathTools.hyperSphereSurfaceArea(n, 1.0);
        double V = S * Math.pow(R, n) / (double)n;
        return V;
    }

    public static boolean isEven(int n) {
        return n % 2 == 0;
    }

    public static double[] linearRegression(double[] x, double[] y) {
        double xysum = 0.0;
        double xxsum = 0.0;
        int i = 0;
        while (i < x.length) {
            xysum += x[i] * y[i];
            xxsum += x[i] * x[i];
            ++i;
        }
        double xsum = 0.0;
        double ysum = 0.0;
        int i2 = 0;
        while (i2 < x.length) {
            xsum += x[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < y.length) {
            ysum += y[i2];
            ++i2;
        }
        double n = x.length;
        double b = (xysum - xsum * ysum / n) / (xxsum - xsum * xsum / n);
        double a = ysum / n - b * xsum / n;
        double[] res = new double[]{a, b};
        return res;
    }
}

