/*
 * Decompiled with CFR 0.152.
 */
package stallone.algebra;

import stallone.api.complex.IComplexArray;
import stallone.api.complex.IComplexIterator;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleIterator;
import stallone.doubles.DoubleArrayTest;

public class ArrayElementProduct {
    public IDoubleArray multiplyToNewDense(IDoubleArray a, IDoubleArray b) {
        IDoubleArray target = a.copy();
        this.multiplyDense(a, b, target);
        return target;
    }

    public IDoubleArray multiplyToNewSparse(IDoubleArray a, IDoubleArray b) {
        IDoubleArray target = a.copy();
        this.multiplySparse(a, b, target);
        return target;
    }

    public void multiplyToSparse(IDoubleArray a, IDoubleArray b) {
        this.multiplySparse(a, b, a);
    }

    public void multiplyToDense(IDoubleArray a, IDoubleArray b) {
        this.multiplyDense(a, b, a);
    }

    public void multiplyDense(IDoubleArray a, IDoubleArray b, IDoubleArray target) {
        DoubleArrayTest.assertEqualDimensions(a, b);
        DoubleArrayTest.assertEqualDimensions(a, target);
        int colsA = a.columns();
        int rowsA = a.rows();
        int i = 0;
        while (i < rowsA) {
            int j = 0;
            while (j < colsA) {
                target.set(i, j, a.get(i, j) * b.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public void multiplySparse(IDoubleArray a, IDoubleArray b, IDoubleArray target) {
        IDoubleIterator it;
        DoubleArrayTest.assertEqualDimensions(a, b);
        DoubleArrayTest.assertEqualDimensions(a, target);
        if (a != target) {
            target.zero();
            it = a.nonzeroIterator();
            while (it.hasNext()) {
                target.set(it.row(), it.column(), it.get());
                it.advance();
            }
        }
        it = b.nonzeroIterator();
        while (it.hasNext()) {
            int i = it.row();
            int j = it.column();
            target.set(i, j, target.get(i, j) * it.get());
            it.advance();
        }
    }

    public IComplexArray multiplyToNewDense(IComplexArray a, IComplexArray b) {
        IComplexArray target = a.copy();
        this.multiplyDense(a, b, target);
        return target;
    }

    public IComplexArray multiplyToNewSparse(IComplexArray a, IComplexArray b) {
        IComplexArray target = a.copy();
        this.multiplySparse(a, b, target);
        return target;
    }

    public void multiplyToDense(IComplexArray a, IComplexArray b) {
        this.multiplyDense(a, b, a);
    }

    public void multiplyToSparse(IComplexArray a, IComplexArray b) {
        this.multiplySparse(a, b, a);
    }

    public void multiplyDense(IComplexArray a, IComplexArray b, IComplexArray target) {
        DoubleArrayTest.assertEqualDimensions(a, b);
        DoubleArrayTest.assertEqualDimensions(a, target);
        int colsA = a.columns();
        int rowsA = a.rows();
        int j = 0;
        while (j < rowsA) {
            int i = 0;
            while (i < colsA) {
                double aRe = a.getRe(i, j);
                double aIm = a.getIm(i, j);
                double bRe = b.getRe(i, j);
                double bIm = b.getIm(i, j);
                target.set(i, j, aRe * bRe - aIm * bIm, aRe * bIm + aIm * bRe);
                ++i;
            }
            ++j;
        }
    }

    public void sumSparse(IComplexArray a, IComplexArray b, IComplexArray target) {
        IComplexIterator it;
        DoubleArrayTest.assertEqualDimensions(a, b);
        DoubleArrayTest.assertEqualDimensions(a, target);
        if (a != target) {
            target.zero();
            it = a.nonzeroComplexIterator();
            while (it.hasNext()) {
                target.set(it.row(), it.column(), it.getRe(), it.getIm());
                it.advance();
            }
        }
        it = b.nonzeroComplexIterator();
        while (it.hasNext()) {
            int i = it.row();
            int j = it.column();
            double aRe = it.getRe();
            double aIm = it.getIm();
            double bRe = b.getRe(i, j);
            double bIm = b.getIm(i, j);
            target.set(i, j, aRe * bRe - aIm * bIm, aRe * bIm + aIm * bRe);
            it.advance();
        }
    }
}

