/*
 * Decompiled with CFR 0.152.
 */
package stallone.algebra;

import stallone.algebra.RealLUDecomposition;
import stallone.algebra.RealQRDecomposition;
import stallone.api.algebra.ILinearMatrixSystem;
import stallone.api.algebra.ILinearSystem;
import stallone.api.doubles.IDoubleArray;

public class RealLinearSystem
implements ILinearSystem,
ILinearMatrixSystem {
    IDoubleArray matrixA;
    IDoubleArray coefficientMatrix;
    IDoubleArray solutionMatrix;
    RealLUDecomposition luDecomposition;
    RealQRDecomposition qrDecomposition;

    @Override
    public void setMatrix(IDoubleArray matrix) {
        this.matrixA = matrix;
        this.luDecomposition = null;
        this.qrDecomposition = null;
    }

    @Override
    public void setCoefficientVector(IDoubleArray coefficientVector) {
        this.coefficientMatrix = coefficientVector.copy();
    }

    @Override
    public void setCoefficientMatrix(IDoubleArray coefficientMatrix) {
        this.coefficientMatrix = coefficientMatrix;
    }

    @Override
    public void perform() {
        if (this.matrixA.rows() == this.matrixA.columns()) {
            if (this.luDecomposition == null) {
                this.luDecomposition = new RealLUDecomposition();
                this.luDecomposition.setMatrix(this.matrixA);
                this.luDecomposition.perform();
            }
            this.solutionMatrix = this.luDecomposition.solve(this.coefficientMatrix);
        } else {
            if (this.qrDecomposition == null) {
                this.qrDecomposition = new RealQRDecomposition();
                this.qrDecomposition.setMatrix(this.matrixA);
                this.qrDecomposition.perform();
            }
            this.solutionMatrix = this.qrDecomposition.solve(this.coefficientMatrix);
        }
    }

    @Override
    public IDoubleArray getSolutionVector() {
        return this.solutionMatrix.viewColumn(0);
    }

    @Override
    public IDoubleArray getSolutionMatrix() {
        return this.solutionMatrix;
    }
}

