/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.cluster;

import stallone.api.API;
import stallone.api.cluster.IClustering;
import stallone.api.datasequence.IDataInput;
import stallone.api.datasequence.IDataSequence;
import stallone.api.discretization.IDiscretization;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IMetric;
import stallone.api.ints.IIntArray;
import stallone.api.ints.Ints;
import stallone.doubles.PrimitiveDoubleTools;

public class ClusterUtilities {
    private IClustering perform(IClustering clustering) {
        clustering.perform();
        return clustering;
    }

    public IClustering kmeans(IDataSequence data, IMetric<IDoubleArray> metric, int k, int maxIter) {
        return this.perform(API.clusterNew.kmeans(data, metric, k, maxIter));
    }

    public IClustering kmeans(IDataInput data, IMetric<IDoubleArray> metric, int k, int maxIter) {
        return this.perform(API.clusterNew.kmeans(data, metric, k, maxIter));
    }

    public IClustering kmeans(IDataSequence data, int k, int maxIter) {
        return this.perform(API.clusterNew.kmeans(data, k, maxIter));
    }

    public IClustering kmeans(IDataInput data, int k, int maxIter) {
        return this.perform(API.clusterNew.kmeans(data, k, maxIter));
    }

    public IClustering kmeans(IDataSequence data, int k) {
        return this.perform(API.clusterNew.kmeans(data, k));
    }

    public IClustering kmeans(IDataInput data, int k) {
        return this.perform(API.clusterNew.kmeans(data, k));
    }

    public IClustering kcenter(IDataSequence data, IMetric<?> metric, int k) {
        return this.perform(API.clusterNew.kcenter(data, k));
    }

    public IClustering kcenter(IDataInput data, IMetric<?> metric, int k) {
        return this.perform(API.clusterNew.kcenter(data, k));
    }

    public IClustering regspace(IDataSequence data, IMetric<IDoubleArray> metric, double dmin) {
        return this.perform(API.clusterNew.regspace(data, metric, dmin));
    }

    public IClustering regspace(IDataInput data, IMetric<IDoubleArray> metric, double dmin) {
        return this.perform(API.clusterNew.regspace(data, metric, dmin));
    }

    public IClustering densityBased(IDataSequence data, IMetric metric, double dmin, int minpts) {
        return this.perform(API.clusterNew.densitybased(data, metric, dmin, minpts));
    }

    public IClustering densityBased(IDataSequence data, double dmin, int minpts) {
        return this.perform(API.clusterNew.densitybased(data, dmin, minpts));
    }

    public IClustering densityBased(IDataSequence data, int N) {
        return this.perform(API.clusterNew.densitybased(data, N));
    }

    public IIntArray discretize(IDataSequence data, IDiscretization disc) {
        IIntArray res = Ints.create.array(data.size());
        int i = 0;
        while (i < data.size()) {
            res.set(i, disc.assign(data.get(i)));
            ++i;
        }
        return res;
    }

    public IDoubleArray clusterSizes(Iterable<IDoubleArray> data, IDataSequence centers, IMetric<IDoubleArray> metric, IIntArray assignment) {
        double[] res = new double[centers.size()];
        double[] counts = new double[centers.size()];
        int k = 0;
        for (IDoubleArray x : data) {
            int c;
            int n = c = assignment.get(k);
            counts[n] = counts[n] + 1.0;
            double d = metric.distance(x, centers.get(c));
            int n2 = c;
            res[n2] = res[n2] + d * d;
            ++k;
        }
        int i = 0;
        while (i < res.length) {
            res[i] = Math.sqrt(res[i] / counts[i]);
            ++i;
        }
        return API.doublesNew.array(res);
    }

    public double clusterIndexSizeImbalance(IIntArray assignment) {
        double[] sizes = new double[API.ints.max(assignment) + 1];
        int i = 0;
        while (i < assignment.size()) {
            int n = assignment.get(i);
            sizes[n] = sizes[n] + 1.0;
            ++i;
        }
        double meansize = PrimitiveDoubleTools.mean(sizes);
        int i2 = 0;
        while (i2 < sizes.length) {
            int n = i2++;
            sizes[n] = sizes[n] - meansize;
        }
        return PrimitiveDoubleTools.norm(sizes);
    }

    public double clusterNoncompactness(Iterable<IDoubleArray> data, IDataSequence centers, IMetric<IDoubleArray> metric, IIntArray assignment) {
        double res = 0.0;
        int k = 0;
        for (IDoubleArray x : data) {
            int c = assignment.get(k);
            double d = metric.distance(x, centers.get(c));
            res += d * d;
            ++k;
        }
        return Math.sqrt(res / (double)k);
    }

    public double clusterIndexDaviesBouldin(Iterable<IDoubleArray> data, IDataSequence centers, IMetric<IDoubleArray> metric, IIntArray assignment) {
        IDoubleArray D = this.clusterSizes(data, centers, metric, assignment);
        double[][] DBdist = new double[centers.size()][centers.size()];
        int i = 0;
        while (i < centers.size() - 1) {
            int j = i + 1;
            while (j < centers.size()) {
                DBdist[i][j] = (D.get(i) + D.get(j)) / metric.distance(centers.get(i), centers.get(j));
                System.out.println("d_i = " + D.get(i));
                System.out.println("d_j = " + D.get(j));
                System.out.println("d_ij = " + metric.distance(centers.get(i), centers.get(j)));
                System.out.println("DB = " + DBdist[i][j]);
                System.out.println();
                ++j;
            }
            ++i;
        }
        double res = 0.0;
        int i2 = 0;
        while (i2 < DBdist.length) {
            res += PrimitiveDoubleTools.max(DBdist[i2]);
            ++i2;
        }
        return res / (double)centers.size();
    }

    public IDoubleArray membershipToState(IClustering crisp, int state) {
        IIntArray clusterIndexes = crisp.getClusterIndexes();
        IDoubleArray res = Doubles.create.array(clusterIndexes.size());
        int i = 0;
        while (i < res.size()) {
            if (clusterIndexes.get(i) == state) {
                res.set(i, 1.0);
            } else {
                res.set(i, 0.0);
            }
            ++i;
        }
        return res;
    }
}

