/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.complex;

import stallone.api.complex.IComplexArray;
import stallone.api.complex.IComplexIterator;
import stallone.api.doubles.IDoubleArray;
import stallone.doubles.AbstractDoubleArray;

public class ImaginaryView
extends AbstractDoubleArray {
    IComplexArray arr;

    public ImaginaryView(IComplexArray _arr) {
        this.arr = _arr;
    }

    @Override
    public int size() {
        return this.arr.size();
    }

    @Override
    public int order() {
        return this.arr.order();
    }

    @Override
    public int rows() {
        return this.arr.rows();
    }

    @Override
    public int columns() {
        return this.arr.columns();
    }

    @Override
    public double get(int i) {
        return this.arr.getIm(i);
    }

    @Override
    public double get(int i, int j) {
        return this.arr.getIm(i, j);
    }

    @Override
    public void set(int i, double x) {
        this.arr.setIm(i, x);
    }

    @Override
    public void set(int i, int j, double x) {
        this.arr.setIm(i, j, x);
    }

    @Override
    public void zero() {
        IComplexIterator it = this.arr.nonzeroComplexIterator();
        while (it.hasNext()) {
            it.setIm(0.0);
            it.advance();
        }
    }

    @Override
    public double[] getArray() {
        return this.arr.getImaginaryArray();
    }

    @Override
    public double[][] getTable() {
        return this.arr.getImaginaryTable();
    }

    @Override
    public double[] getRow(int i) {
        return this.arr.getImaginaryRow(i);
    }

    @Override
    public double[] getColumn(int j) {
        return this.arr.getImaginaryColumn(j);
    }

    @Override
    public IDoubleArray copy() {
        return new ImaginaryView(this.arr.copy());
    }

    @Override
    public IDoubleArray create(int size) {
        return new ImaginaryView(this.arr.create(size));
    }

    @Override
    public IDoubleArray create(int rows, int columns) {
        return new ImaginaryView(this.arr.create(rows, columns));
    }

    @Override
    public boolean isSparse() {
        return this.arr.isSparse();
    }
}

