/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.datasequence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import stallone.api.API;
import stallone.api.algebra.Algebra;
import stallone.api.datasequence.DataSequence;
import stallone.api.datasequence.IDataReader;
import stallone.api.datasequence.IDataSequence;
import stallone.api.datasequence.IDataSequenceLoader;
import stallone.api.datasequence.IDataWriter;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.ints.IIntArray;
import stallone.datasequence.DataList;
import stallone.datasequence.DataSequenceConcatenated;
import stallone.datasequence.DataSequenceConcatenatedInterleaved;

public class DataSequenceUtilities {
    public List<IDataSequence> loadSubset(IDataSequenceLoader loader, IIntArray indexes) throws IOException {
        ArrayList<IDataSequence> res = new ArrayList<IDataSequence>();
        DataList list = null;
        int lastTraj = -1;
        int i = 0;
        while (i < indexes.rows()) {
            int itraj = indexes.get(i, 0);
            if (itraj != lastTraj) {
                if (list != null) {
                    res.add(list);
                }
                list = new DataList();
                lastTraj = itraj;
            }
            int iindex = indexes.get(i, 1);
            list.add(loader.get(itraj, iindex));
            ++i;
        }
        res.add(list);
        return res;
    }

    public IDataSequence loadSequence(String inputFile) {
        IDataSequence res = null;
        try {
            IDataReader input = API.dataNew.reader(inputFile);
            res = input.load();
        }
        catch (IOException ex) {
            Logger.getLogger(DataSequenceUtilities.class.getName()).log(Level.SEVERE, null, ex);
            System.exit(0);
        }
        return res;
    }

    public IDoubleArray toArray(IDataSequence inp) {
        int n = inp.size();
        int d = inp.dimension();
        IDoubleArray M = API.doublesNew.matrix(n, d);
        int i = 0;
        while (i < n) {
            IDoubleArray r = inp.get(i);
            int j = 0;
            while (j < d) {
                M.set(i, j, r.get(j));
                ++j;
            }
            ++i;
        }
        return M;
    }

    public IDoubleArray readColumn(IDataSequence inp, int columnIndex) {
        IDoubleArray col = Doubles.create.array(inp.size());
        int i = 0;
        while (i < inp.size()) {
            col.set(i, inp.get(i).get(columnIndex));
            ++i;
        }
        return col;
    }

    public IDoubleArray readColumn(String inputFile, int columnIndex) {
        IDoubleArray res = null;
        try {
            IDataReader input = DataSequence.create.readerASCII(inputFile);
            input.scan();
            res = Doubles.create.denseColumn(input.size());
            int i = 0;
            while (i < res.size()) {
                res.set(i, input.get(i).get(columnIndex));
                ++i;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(DataSequenceUtilities.class.getName()).log(Level.SEVERE, null, ex);
            System.exit(0);
        }
        return res;
    }

    public void writeSequence(IDataSequence data, String file) throws IOException {
        IDataWriter writer = DataSequence.create.writer(file, data.size(), data.dimension());
        writer.addAll(data);
        writer.close();
    }

    public int size(List<IDataSequence> data) {
        int size = 0;
        int i = 0;
        while (i < data.size()) {
            size += data.size();
            ++i;
        }
        return size;
    }

    public IDataSequence concat(List<IDataSequence> data) {
        return new DataSequenceConcatenated(data);
    }

    public IDataSequence concat(List<IDataSequence> data, int interleaf) {
        return new DataSequenceConcatenatedInterleaved(data, interleaf);
    }

    public IDoubleArray mean(Iterable<IDoubleArray> data) {
        IDoubleArray res = null;
        int N = 0;
        for (IDoubleArray x : data) {
            if (res == null) {
                res = x.copy();
            } else {
                Algebra.util.addTo(res, x);
            }
            ++N;
        }
        Algebra.util.scale(1.0 / (double)N, res);
        return res;
    }

    public double rgyr(Iterable<IDoubleArray> data) {
        IDoubleArray mean = this.mean(data);
        double sum = 0.0;
        int N = 0;
        for (IDoubleArray x : data) {
            double d = Algebra.util.norm(Algebra.util.subtract(x, mean));
            sum += d * d;
            ++N;
        }
        return 1.0 / (double)N * Math.sqrt(sum);
    }

    public double rmax(Iterable<IDoubleArray> data) {
        IDoubleArray mean = this.mean(data);
        double max = 0.0;
        for (IDoubleArray x : data) {
            double d = Algebra.util.norm(Algebra.util.subtract(x, mean));
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }
}

