/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.graph;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import stallone.api.doubles.IDoubleArray;
import stallone.api.graph.Graph;
import stallone.api.graph.IIntConnectivity;
import stallone.api.graph.IIntGraph;
import stallone.api.ints.IIntArray;
import stallone.ints.PrimitiveIntTools;

public class GraphUtilities {
    public List<IIntArray> connectedComponents(IIntGraph g) {
        IIntConnectivity res = Graph.create.connectivityChecker(g);
        List<IIntArray> strongComponents = res.getStrongComponents();
        return strongComponents;
    }

    public List<IIntArray> connectedComponents(IDoubleArray m) {
        IIntConnectivity res = Graph.create.connectivityChecker(Graph.create.intMatrixGraph(m));
        List<IIntArray> strongComponents = res.getStrongComponents();
        return strongComponents;
    }

    private int[] bfs(IIntGraph g, boolean[] _visited, int[] distances, int[] predecessors, int s) {
        boolean[] visited = _visited;
        if (_visited == null) {
            visited = new boolean[g.numberOfNodes()];
        }
        Arrays.fill(distances, -1);
        distances[s] = 0;
        predecessors[s] = -1;
        LinkedList<Integer> found = new LinkedList<Integer>();
        LinkedList<Integer> todo = new LinkedList<Integer>();
        todo.add(new Integer(s));
        visited[s] = true;
        while (todo.size() > 0) {
            int v = (Integer)todo.remove(0);
            IIntArray neighbors = g.getNeighbors(v);
            int i = 0;
            while (i < neighbors.size()) {
                int neighbor = neighbors.get(i);
                if (!visited[neighbor]) {
                    distances[neighbor] = distances[v] + 1;
                    predecessors[neighbor] = v;
                    todo.add(new Integer(neighbor));
                    visited[neighbor] = true;
                }
                ++i;
            }
            found.add(new Integer(v));
        }
        return PrimitiveIntTools.List2Array(found);
    }

    public int[] bfs(IIntGraph g, int s) {
        int n = g.numberOfNodes();
        boolean[] visited = new boolean[n];
        int[] distances = new int[n];
        int[] predecessors = new int[n];
        Arrays.fill(distances, -1);
        return this.bfs(g, visited, distances, predecessors, s);
    }

    public int[][] bfsAll(IIntGraph g) {
        int n = g.numberOfNodes();
        boolean[] visited = new boolean[n];
        int[] distances = new int[n];
        int[] predecessors = new int[n];
        LinkedList<int[]> found = new LinkedList<int[]>();
        int i = 0;
        while (i < visited.length) {
            if (!visited[i]) {
                found.add(this.bfs(g, visited, distances, predecessors, i));
            }
            ++i;
        }
        return PrimitiveIntTools.List2Array2(found);
    }
}

