/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.hmm;

import java.util.List;
import stallone.api.API;
import stallone.api.algebra.Algebra;
import stallone.api.cluster.Cluster;
import stallone.api.cluster.IClustering;
import stallone.api.datasequence.DataSequence;
import stallone.api.datasequence.IDataSequence;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.function.IParametricFunction;
import stallone.api.hmm.IExpectationMaximization;
import stallone.api.hmm.IHMMOptimizer;
import stallone.api.hmm.IHMMParameters;
import stallone.api.ints.IIntArray;
import stallone.api.intsequence.IntSequence;
import stallone.api.stat.IParameterEstimator;
import stallone.api.stat.Statistics;
import stallone.hmm.EM;
import stallone.hmm.EMHierarchical;
import stallone.hmm.EMMultiStart;
import stallone.hmm.HMMParameters;
import stallone.hmm.pmm.NinjaEstimator;
import stallone.stat.DiscreteDistribution;
import stallone.stat.GaussianUnivariate;

public class HMMFactory {
    private IDataSequence concat(List<IDataSequence> _obs, int maxsize) {
        Object res = null;
        int size = DataSequence.util.size(_obs);
        int interleaf = Math.max(1, size / maxsize);
        return DataSequence.util.concat(_obs, interleaf);
    }

    private IDoubleArray[] initialParametersGaussian1D(List<IDataSequence> _obs, int nstates) {
        IDataSequence obscat = this.concat(_obs, nstates * 1000);
        System.out.println("Data concatenated to size " + obscat.size());
        System.out.println("Clustering...");
        IClustering cluster = Cluster.util.densityBased(obscat, nstates);
        System.out.println("done.");
        IIntArray ci = cluster.getClusterIndexes();
        IDoubleArray[] res = new IDoubleArray[nstates];
        int state = 0;
        while (state < nstates) {
            IParameterEstimator estimator = Statistics.create.parameterEstimatorGaussian1D();
            res[state] = estimator.estimate(obscat, Cluster.util.membershipToState(cluster, state));
            ++state;
        }
        return res;
    }

    public IDoubleArray[] initialParametersGaussian(List<IDataSequence> _obs, int nstates) {
        int dim = _obs.get(0).dimension();
        if (dim < 1) {
            throw new IllegalArgumentException("Data dimension is <= 0 but must be 1 at least");
        }
        if (dim == 1) {
            return this.initialParametersGaussian1D(_obs, nstates);
        }
        throw new UnsupportedOperationException("N-dimensional Gaussian HMM not yet implemented");
    }

    public IHMMParameters parameters(int nstates, boolean _isReversible, boolean _isStationary) {
        HMMParameters par = new HMMParameters(nstates, _isReversible, _isStationary);
        IDoubleArray T0 = API.doublesNew.matrix(nstates, nstates);
        API.doubles.fill(T0, 1.0 / (double)nstates);
        par.setTransitionMatrix(T0);
        return par;
    }

    public IHMMParameters parameters(int nstates, boolean _isReversible, boolean _isStationary, IParametricFunction outputModel) {
        IHMMParameters par = this.parameters(nstates, _isReversible, _isStationary);
        int npar = outputModel.getParameters().size();
        int i = 0;
        while (i < nstates) {
            par.setOutputParameters(i, API.doublesNew.array(npar));
            ++i;
        }
        return par;
    }

    public IExpectationMaximization em(List<IDataSequence> _obs, IParametricFunction outputModel, IParameterEstimator outputEstimator, IHMMParameters initialParameters) {
        boolean eventBased = true;
        boolean saveMemory = false;
        EM em = new EM(_obs, eventBased, initialParameters.getNStates(), initialParameters.isReversible(), outputModel, outputEstimator, saveMemory);
        em.setInitialParameters(initialParameters);
        return em;
    }

    public IExpectationMaximization em(List<IDataSequence> _obs, IParametricFunction outputModel, IParameterEstimator outputEstimator, List<IIntArray> initialPaths, boolean reversible) {
        boolean eventBased = true;
        boolean saveMemory = false;
        int nstates = IntSequence.util.max(initialPaths) + 1;
        EM em = new EM(_obs, eventBased, nstates, reversible, outputModel, outputEstimator, saveMemory);
        IHMMParameters par0 = this.parameters(nstates, reversible, true, outputModel);
        em.setInitialParameters(par0);
        em.setInitialPaths(initialPaths);
        return em;
    }

    public IHMMOptimizer emMultiStart(List<IDataSequence> _obs, IParametricFunction outputModel, IParameterEstimator outputEstimator, IHMMParameters[] initialParameters, int nscansteps, int nscans, int nconvsteps, double dectol) {
        boolean eventBased = true;
        boolean saveMemory = false;
        EMMultiStart em = new EMMultiStart(_obs, outputModel, outputEstimator, initialParameters);
        em.setNumberOfScanningSteps(nscansteps);
        em.setNumberOfConvergenceSteps(nconvsteps);
        em.setLikelihoodDecreaseTolerance(dectol);
        return em;
    }

    public IHMMOptimizer emHierarchical(List<IDataSequence> _obs, IParametricFunction outputModel, IParameterEstimator outputEstimator, IHMMParameters[] initialParameters, int nInitialSteps, double dectol, boolean saveMemory) {
        boolean eventBased = true;
        EMHierarchical em = new EMHierarchical(_obs, outputModel, outputEstimator);
        em.setInitialParameters(initialParameters);
        em.setInitialNumberOfSteps(nInitialSteps);
        em.setLikelihoodDecreaseTolerance(dectol);
        return em;
    }

    public IExpectationMaximization emDiscrete(List<IDataSequence> _obs, IHMMParameters initialParameters, double[] prior) {
        boolean eventBased = false;
        boolean saveMemory = false;
        DiscreteDistribution dd = new DiscreteDistribution(initialParameters.getOutputParameters(0));
        dd.setPrior(prior);
        EM em = new EM(_obs, eventBased, initialParameters.getNStates(), initialParameters.isReversible(), dd, dd, saveMemory);
        em.setInitialParameters(initialParameters);
        return em;
    }

    public IExpectationMaximization emDiscrete(List<IDataSequence> _obs, IHMMParameters initialParameters) {
        boolean eventBased = false;
        boolean saveMemory = false;
        DiscreteDistribution dd = new DiscreteDistribution(initialParameters.getOutputParameters(0));
        EM em = new EM(_obs, eventBased, initialParameters.getNStates(), initialParameters.isReversible(), dd, dd, saveMemory);
        em.setInitialParameters(initialParameters);
        return em;
    }

    public IExpectationMaximization emGaussian(List<IDataSequence> _obs, IHMMParameters initialParameters) {
        boolean eventBased = true;
        boolean saveMemory = false;
        GaussianUnivariate gauss = new GaussianUnivariate(0.0, 1.0);
        EM em = new EM(_obs, eventBased, initialParameters.getNStates(), initialParameters.isReversible(), gauss, gauss, saveMemory);
        em.setInitialParameters(initialParameters);
        return em;
    }

    public IExpectationMaximization emGaussian(List<IDataSequence> _obs, List<IIntArray> initialPaths, boolean reversible) {
        boolean eventBased = true;
        boolean saveMemory = false;
        GaussianUnivariate gauss = new GaussianUnivariate(0.0, 1.0);
        int nstates = IntSequence.util.max(initialPaths) + 1;
        EM em = new EM(_obs, eventBased, nstates, reversible, gauss, gauss, saveMemory);
        em.setInitialPaths(initialPaths);
        return em;
    }

    public IExpectationMaximization emGaussian(List<IDataSequence> _obs, int nstates) {
        boolean eventBased = true;
        IDoubleArray T = Algebra.util.add(Doubles.create.diag(nstates, 0.9), Doubles.create.matrix(nstates, nstates, 0.1 / (double)nstates));
        IDoubleArray p0 = Doubles.create.array(nstates, 1.0 / (double)nstates);
        IDoubleArray[] parOut = this.initialParametersGaussian(_obs, nstates);
        HMMParameters initialParameters = new HMMParameters(T, p0, parOut, false, true);
        return this.emGaussian(_obs, initialParameters);
    }

    public IExpectationMaximization pmm(List<IIntArray> _dtrajs, int nHiddenStates, int lag, int timeshift, int nconvsteps, double dectol, IDoubleArray TCinit, IDoubleArray chiInit) {
        NinjaEstimator ninja = new NinjaEstimator(_dtrajs);
        ninja.setNHiddenStates(nHiddenStates);
        ninja.setNIterHMMMax(nconvsteps);
        ninja.setHMMLikelihoodMaxIncrease(dectol);
        ninja.setTau(lag);
        ninja.setTimeshift(timeshift);
        if (TCinit != null && chiInit != null) {
            ninja.setInit(TCinit, chiInit);
        }
        return ninja;
    }

    public IExpectationMaximization pmm(List<IIntArray> _dtrajs, int nHiddenStates, int lag) {
        int timeshift = Math.min(lag / 10, 1);
        int nconvsteps = 100 * nHiddenStates * nHiddenStates;
        double dectol = -0.1;
        IDoubleArray TCinit = null;
        IDoubleArray chiInit = null;
        return this.pmm(_dtrajs, nHiddenStates, lag, timeshift, nconvsteps, dectol, TCinit, chiInit);
    }
}

