/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import stallone.api.API;
import stallone.api.io.IO;
import stallone.io.BlockFileReader;
import stallone.io.CachedAsciiFileReader;
import stallone.io.RecursiveFileList;
import stallone.io.WildcardFilter;

public class IOUtilities {
    public static final Logger logger = Logger.getLogger(IOUtilities.class.getName());

    public void error(String msg) {
        Thread.dumpStack();
        System.out.println();
        System.out.println("ERROR: " + msg);
        System.exit(-1);
    }

    public List<File> listFilesRecursive(String startingDirectory, String filter) throws FileNotFoundException {
        return new RecursiveFileList(startingDirectory, filter).getFiles();
    }

    public List<File> listFilesRecursive(File startingDirectory, String filter) throws FileNotFoundException {
        return new RecursiveFileList(startingDirectory, filter).getFiles();
    }

    public List<File> listFilesRecursive(String startingDirectory) throws FileNotFoundException {
        return new RecursiveFileList(startingDirectory).getFiles();
    }

    public List<File> listFilesRecursive(File startingDirectory) throws FileNotFoundException {
        return new RecursiveFileList(startingDirectory).getFiles();
    }

    public List<File> listFiles(String[] wildcardFilenames) {
        ArrayList<File> foundFiles = new ArrayList<File>();
        String[] stringArray = wildcardFilenames;
        int n = wildcardFilenames.length;
        int n2 = 0;
        while (n2 < n) {
            String wildcardFilename = stringArray[n2];
            foundFiles.addAll(this.listFiles(wildcardFilename));
            ++n2;
        }
        return foundFiles;
    }

    public List<File> listFiles(String wildcardFilename) {
        File[] filesInDir;
        ArrayList<File> foundFiles = new ArrayList<File>();
        File f = new File(wildcardFilename);
        File parent = f.getParentFile();
        if (parent == null) {
            parent = new File(".");
        }
        File[] fileArray = filesInDir = parent.listFiles(new WildcardFilter(f.getName()));
        int n = filesInDir.length;
        int n2 = 0;
        while (n2 < n) {
            File foundFile = fileArray[n2];
            foundFiles.add(foundFile);
            ++n2;
        }
        return foundFiles;
    }

    public List<String> listFileNames(String wildcardFilename) {
        return this.toStrings(this.listFiles(wildcardFilename));
    }

    public String getExtension(String filename) {
        int lastIndex = filename.lastIndexOf(".");
        return filename.substring(lastIndex + 1);
    }

    public String getExtension(File f) {
        return this.getExtension(f.getName());
    }

    public String getBasename(File f) {
        return this.getBasename(f.getName());
    }

    public String getBasename(String fullname) {
        String filename = new File(fullname).getName();
        int index = filename.lastIndexOf(46);
        if (index == -1) {
            return filename;
        }
        return filename.substring(0, index);
    }

    public String getFilename(String fullname) {
        return new File(fullname).getName();
    }

    public String getDirectory(String fullname) {
        if (!fullname.contains("/")) {
            return ".";
        }
        return fullname.substring(0, fullname.lastIndexOf("/"));
    }

    public boolean canCreateFile(String filename) {
        IO.util.error("Implement me: IOUtilities.canCreateFile(String)");
        return true;
    }

    public List<String> toStrings(List<File> files) {
        ArrayList<String> res = new ArrayList<String>();
        for (File f : files) {
            res.add(f.getAbsolutePath());
        }
        return res;
    }

    public List<File> toFiles(List<String> files) {
        ArrayList<File> res = new ArrayList<File>();
        for (String f : files) {
            res.add(new File(f));
        }
        return res;
    }

    public String[] readLines(String fileName) throws IOException {
        CachedAsciiFileReader reader = API.ioNew.asciiReader(fileName);
        reader.scan();
        int nlines = reader.getNumberOfLines();
        String[] res = new String[nlines];
        int i = 0;
        while (i < res.length) {
            res[i] = reader.getLine(i);
            ++i;
        }
        return res;
    }

    public String[][] readWords(String fileName) throws IOException {
        String[] lines = this.readLines(fileName);
        String[][] words = new String[lines.length][];
        int i = 0;
        while (i < words.length) {
            words[i] = API.str.split(lines[i]);
            ++i;
        }
        return words;
    }

    public double[][] readDoubleMatrix(String fileName) throws FileNotFoundException, IOException {
        BlockFileReader reader = API.ioNew.asciiNumberReader(fileName);
        return reader.getLargestDoubleBlock();
    }

    public int[][] readIntMatrix(String fileName) throws FileNotFoundException, IOException {
        BlockFileReader reader = API.ioNew.asciiNumberReader(fileName);
        return reader.getLargestIntBlock();
    }

    public double[] readDoubleColumn(String fileName, int c) throws FileNotFoundException, IOException {
        BlockFileReader reader = API.ioNew.asciiNumberReader(fileName);
        return reader.getDoubleColumn(c);
    }

    public int[] readIntColumn(String fileName, int c) throws FileNotFoundException, IOException {
        BlockFileReader reader = API.ioNew.asciiNumberReader(fileName);
        return reader.getIntColumn(c);
    }

    public void writeString(String fileName, String content) {
        try {
            FileOutputStream out = new FileOutputStream(fileName);
            out.write(content.getBytes());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

