/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.potential;

import stallone.api.doubles.IDoubleArray;
import stallone.api.ints.IIntArray;
import stallone.api.potential.IEnergyModel;
import stallone.function.JEPFunctionC1;
import stallone.potential.AssymetricBistablePotential;
import stallone.potential.BistablePotential;
import stallone.potential.CompositeEnergyModel;
import stallone.potential.CoulombSystem;
import stallone.potential.FoldingModelSimple;
import stallone.potential.GenericPotential;
import stallone.potential.HarmonicNetwork;
import stallone.potential.HarmonicOscillator;
import stallone.potential.LennardJonesSystem;

public class PotentialFactory {
    public IEnergyModel multivariateFromExpression(String[] variables, String expression, String ... derivatives) {
        return new GenericPotential(new JEPFunctionC1(variables, expression, derivatives));
    }

    public IEnergyModel univariateFromExpression(String expression, String ... derivatives) {
        return new GenericPotential(new JEPFunctionC1(expression, derivatives));
    }

    public IEnergyModel sumOfTerms(IEnergyModel ... terms) {
        CompositeEnergyModel res = new CompositeEnergyModel();
        IEnergyModel[] iEnergyModelArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            IEnergyModel term = iEnergyModelArray[n2];
            res.add(term);
            ++n2;
        }
        return res;
    }

    public IEnergyModel bistable(double k2, double k4, double d0) {
        return new BistablePotential(k2, k4, d0);
    }

    public IEnergyModel bistableAssymetric(double k1, double k2, double k4, double d0) {
        return new AssymetricBistablePotential(k1, k2, k4, d0);
    }

    public IEnergyModel foldingModel(double df, double kf, double du, double ku, int ndim) {
        return new FoldingModelSimple(df, kf, du, ku, ndim);
    }

    public IEnergyModel coulomb(IDoubleArray charges, double epsilonr) {
        return new CoulombSystem(charges, epsilonr);
    }

    public IEnergyModel coulomb(IDoubleArray charges, IIntArray bonded, double epsilonr) {
        return new CoulombSystem(charges, bonded, epsilonr);
    }

    public IEnergyModel harmonicNetwork(int natoms) {
        return new HarmonicNetwork(natoms);
    }

    public IEnergyModel harmonicOscillator(double k) {
        return new HarmonicOscillator(k);
    }

    public IEnergyModel lennardJones(int natoms, IDoubleArray radii, IDoubleArray epsilons) {
        return new LennardJonesSystem(natoms, radii, epsilons);
    }

    public IEnergyModel lennardJones(int natoms, IDoubleArray radii, IDoubleArray epsilons, IIntArray bonded) {
        return new LennardJonesSystem(natoms, radii, epsilons, bonded);
    }
}

