/*
 * Decompiled with CFR 0.152.
 */
package stallone.cluster;

import java.util.Iterator;
import stallone.api.cluster.IClustering;
import stallone.api.datasequence.IDataInput;
import stallone.api.datasequence.IDataSequence;
import stallone.api.discretization.IDiscretization;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IMetric;
import stallone.doubles.EuclideanDistance;

public abstract class AbstractRegularClustering
implements IClustering {
    protected IDataSequence clusterCenters;
    protected Iterable<IDoubleArray> data;
    protected int datasize;
    protected IMetric<IDoubleArray> metric = new EuclideanDistance();
    protected boolean resultsAvailable;
    protected IDiscretization voronoiPartitioning;

    @Override
    public IDiscretization getClusterAssignment() {
        return this.voronoiPartitioning;
    }

    @Override
    public int getNumberOfClusters() {
        this.requireResultsAvailable();
        return this.clusterCenters.size();
    }

    @Override
    public abstract void perform();

    protected void requireResultsAvailable() {
        if (this.resultsAvailable) {
            return;
        }
        throw new RuntimeException("Trying to query results, which are not available.");
    }

    @Override
    public void setInput(IDataSequence _data) {
        this.resultsAvailable = false;
        this.data = _data;
        this.datasize = _data.size();
    }

    @Override
    public void setInput(IDataInput _data) {
        this.resultsAvailable = false;
        this.data = _data.singles();
        this.datasize = _data.size();
    }

    @Override
    public void setMetric(IMetric<IDoubleArray> _metric) {
        this.resultsAvailable = false;
        this.metric = _metric;
    }

    @Override
    public Iterator<IDoubleArray> clusterCenterIterator() {
        return this.clusterCenters.iterator();
    }

    public IDoubleArray getClusterCenter(int i) {
        return this.clusterCenters.get(i);
    }

    @Override
    public IDataSequence getClusterCenters() {
        return this.clusterCenters;
    }

    @Override
    public int assign(IDoubleArray data) {
        return this.voronoiPartitioning.assign(data);
    }

    @Override
    public IDoubleArray getRepresentative(IDoubleArray p) {
        return this.clusterCenters.get(this.assign(p));
    }

    @Override
    public IDoubleArray assignFuzzy(IDoubleArray data) {
        return this.voronoiPartitioning.assignFuzzy(data);
    }
}

