/*
 * Decompiled with CFR 0.152.
 */
package stallone.cluster;

import java.util.Iterator;
import stallone.api.cluster.IClustering;
import stallone.api.datasequence.DataSequence;
import stallone.api.datasequence.IDataInput;
import stallone.api.datasequence.IDataList;
import stallone.api.datasequence.IDataSequence;
import stallone.api.discretization.IDiscretization;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IMetric;
import stallone.api.ints.IIntArray;
import stallone.api.ints.Ints;
import stallone.doubles.fastutils.DoubleArrayList;
import stallone.doubles.fastutils.IntArrayList;

public class KCenterClustering
implements IClustering,
IDiscretization {
    private IDataList clusters = DataSequence.create.list();
    private Iterable<IDoubleArray> data;
    private int size = 0;
    private IMetric<IDoubleArray> distanceMetric;
    private int numberOfClusters;
    private IntArrayList assignedClusters;
    private long randomSeed;

    @Override
    public void perform() {
        DoubleArrayList minDistances = new DoubleArrayList();
        Iterator<IDoubleArray> it = this.data.iterator();
        if (!it.hasNext()) {
            throw new RuntimeException("Trying to cluster an empty data set");
        }
        IDoubleArray v_0 = it.next().copy();
        this.clusters.add(v_0);
        this.assignedClusters.add(0);
        minDistances.add(0.0);
        System.out.println("KCenter: iteration 1/" + this.numberOfClusters + ".");
        IDoubleArray v_i = null;
        double maxMinDistance = 0.0;
        int count = 0;
        while (it.hasNext()) {
            IDoubleArray p_j = it.next().copy();
            double d = this.distanceMetric.distance(p_j, v_0);
            minDistances.add(d);
            if (d >= maxMinDistance) {
                ++count;
                maxMinDistance = d;
                v_i = p_j;
            }
            this.assignedClusters.add(0);
        }
        int i = 1;
        while (i < this.numberOfClusters) {
            System.out.println("KCenter: iteration " + (i + 1) + "/" + this.numberOfClusters + ".");
            this.clusters.add(v_i);
            int j = 0;
            maxMinDistance = 0.0;
            IDoubleArray v_next = null;
            it = this.data.iterator();
            while (it.hasNext()) {
                IDoubleArray p_j = it.next().copy();
                double currentDistance = minDistances.get(j);
                double newDistance = this.distanceMetric.distance(p_j, v_i);
                if (newDistance < currentDistance) {
                    this.assignedClusters.set(j, i);
                    minDistances.set(j, newDistance);
                }
                if (minDistances.get(j) >= maxMinDistance) {
                    maxMinDistance = minDistances.get(j);
                    v_next = p_j;
                }
                ++j;
            }
            v_i = v_next;
            ++i;
        }
    }

    @Override
    public void setInput(IDataInput _data) {
        this.data = _data.singles();
        this.size = _data.size();
        this.assignedClusters = new IntArrayList();
    }

    @Override
    public void setInput(IDataSequence datapoints) {
        this.data = datapoints;
        this.size = datapoints.size();
        this.assignedClusters = new IntArrayList();
    }

    @Override
    public void setMetric(IMetric<IDoubleArray> metric) {
        this.distanceMetric = metric;
    }

    public void setNumberOfClusters(int numberOfClusters) {
        this.numberOfClusters = numberOfClusters;
    }

    @Override
    public int getNumberOfClusters() {
        return this.numberOfClusters;
    }

    public void setRandomSeed(long randomSeed) {
        this.randomSeed = randomSeed;
    }

    @Override
    public IDiscretization getClusterAssignment() {
        return this;
    }

    @Override
    public int assign(IDoubleArray p) {
        double minimalDistance = Double.MAX_VALUE;
        int indexOfNearestCluster = -1;
        int i = 0;
        while (i < this.numberOfClusters) {
            IDoubleArray v_i = this.clusters.get(i);
            double currentDistance = this.distanceMetric.distance(p, v_i);
            if (currentDistance < minimalDistance) {
                minimalDistance = currentDistance;
                indexOfNearestCluster = i;
            }
            ++i;
        }
        if (indexOfNearestCluster == -1) {
            throw new RuntimeException("Can not assign cluster.");
        }
        return indexOfNearestCluster;
    }

    @Override
    public IDoubleArray assignFuzzy(IDoubleArray p) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public IDoubleArray getRepresentative(IDoubleArray p) {
        return this.clusters.get(this.assign(p));
    }

    public String getDescriptiveName() {
        return "kcenter";
    }

    @Override
    public Iterator<IDoubleArray> clusterCenterIterator() {
        return this.clusters.iterator();
    }

    @Override
    public IIntArray getClusterIndexes() {
        this.assignedClusters.trim();
        return Ints.create.arrayFrom(this.assignedClusters.elements());
    }

    @Override
    public IDataSequence getClusterCenters() {
        return this.clusters;
    }
}

