/*
 * Decompiled with CFR 0.152.
 */
package stallone.cluster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import stallone.api.algebra.Algebra;
import stallone.api.cluster.IClustering;
import stallone.api.datasequence.DataSequence;
import stallone.api.datasequence.IDataInput;
import stallone.api.datasequence.IDataList;
import stallone.api.datasequence.IDataSequence;
import stallone.api.discretization.Discretization;
import stallone.api.discretization.IDiscretization;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IMetric;
import stallone.api.ints.IIntArray;
import stallone.api.ints.Ints;
import stallone.doubles.EuclideanDistance;
import stallone.doubles.fastutils.IntArrayList;

public class KMeansClustering
implements IClustering {
    private static final int INIT_UNDEFINED = 1;
    private static final int INIT_RANDOM = 2;
    private static final int INIT_BY_INDICES = 3;
    private Iterable<IDoubleArray> data;
    private int size = -1;
    private IMetric<IDoubleArray> metric;
    private IntArrayList assignments;
    private IDataList clusterCenters;
    private int numberOfClusters;
    private int initMode = 1;
    private int maxIterations = 0;
    private IIntArray indices;
    private List<Integer> emptyCenterIndices = new ArrayList<Integer>();
    private IDiscretization voronoiDiscretization;

    public void setInitialClusterCentersByRandom(int numberOfClusters) {
        this.initMode = 2;
        this.numberOfClusters = numberOfClusters;
    }

    public void setInitialClusterCenters(IIntArray indices) {
        this.initMode = 3;
        this.numberOfClusters = indices.size();
        this.indices = indices;
    }

    private void initialize() {
        this.clusterCenters = DataSequence.create.list();
        this.assignments = new IntArrayList();
        if (this.initMode == 2) {
            this.indices = Ints.create.arrayRandomIndexes(this.size, this.numberOfClusters);
        }
        int[] sortedIndexes = Arrays.copyOf(this.indices.getArray(), this.indices.size());
        Arrays.sort(sortedIndexes);
        int i = 0;
        for (IDoubleArray current : this.data) {
            if (Arrays.binarySearch(sortedIndexes, i) >= 0) {
                this.clusterCenters.add(current.copy());
            }
            this.assignments.add(-1);
            ++i;
        }
    }

    @Override
    public void setInput(IDataSequence _data) {
        this.data = _data;
        this.size = _data.size();
        this.assignments = new IntArrayList(_data.size());
    }

    @Override
    public void setInput(IDataInput _data) {
        this.data = _data.singles();
        this.size = _data.size();
        this.assignments = new IntArrayList(this.size);
    }

    @Override
    public void setMetric(IMetric<IDoubleArray> metric) {
        this.metric = metric;
        if (!(metric instanceof EuclideanDistance)) {
            System.out.println("Warning. Not using euclidian metric. This may produce nonsensical results.");
        }
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    @Override
    public void perform() {
        boolean doMoreIterations;
        boolean clustersChanged;
        System.out.println("Starting k-means.");
        this.initialize();
        int loopIdx = 0;
        do {
            doMoreIterations = loopIdx < this.maxIterations || this.maxIterations == 0;
            System.out.println("Iteration step: " + ++loopIdx);
            clustersChanged = this.assign();
            if (!clustersChanged) continue;
            this.updateCenters();
        } while (clustersChanged && doMoreIterations);
        this.voronoiDiscretization = Discretization.create.voronoiDiscretization(this.clusterCenters, this.metric);
    }

    private boolean assign() {
        boolean clustersChanged = false;
        int i = 0;
        for (IDoubleArray current : this.data) {
            int closest = 0;
            double closestDistance = this.metric.distance(current, this.clusterCenters.get(0));
            int j = 1;
            while (j < this.numberOfClusters) {
                double distance = this.metric.distance(current, this.clusterCenters.get(j));
                if (distance < closestDistance) {
                    closestDistance = distance;
                    closest = j;
                }
                ++j;
            }
            if (this.assignments.get(i) != closest) {
                clustersChanged = true;
            }
            this.assignments.set(i, closest);
            ++i;
        }
        return clustersChanged;
    }

    private void updateCenters() {
        int i = 0;
        while (i < this.numberOfClusters) {
            IDoubleArray clusterCenter = this.clusterCenters.get(i);
            clusterCenter.zero();
            ++i;
        }
        double[] assignmentWeight = new double[this.numberOfClusters];
        int j = 0;
        for (IDoubleArray currentVector : this.data) {
            int assignedTo;
            int n = assignedTo = this.assignments.get(j).intValue();
            assignmentWeight[n] = assignmentWeight[n] + 1.0;
            IDoubleArray clusterCenter = this.clusterCenters.get(assignedTo);
            Algebra.util.addTo(clusterCenter, currentVector);
            ++j;
        }
        this.emptyCenterIndices.clear();
        int i22 = 0;
        while (i22 < this.numberOfClusters) {
            if (assignmentWeight[i22] == 0.0) {
                this.emptyCenterIndices.add(i22);
            }
            Algebra.util.scale(1.0 / assignmentWeight[i22], this.clusterCenters.get(i22));
            ++i22;
        }
        if (!this.emptyCenterIndices.isEmpty()) {
            if (this.emptyCenterIndices.size() >= this.numberOfClusters) {
                System.out.println("Fatal error. All cluster centers empty. -> System.exit(1)!");
                System.exit(1);
            } else {
                System.out.printf("Removing %d empty cluster centers.", this.emptyCenterIndices.size());
                for (int i22 : this.emptyCenterIndices) {
                    this.clusterCenters.remove(i22);
                    --this.numberOfClusters;
                }
            }
        }
    }

    @Override
    public int getNumberOfClusters() {
        return this.numberOfClusters;
    }

    public int getClusterIndex(int i) {
        return this.assignments.get(i);
    }

    public IDoubleArray getMembership(int i) {
        IDoubleArray membership = Doubles.create.array(this.numberOfClusters);
        membership.set(i, 1.0);
        return membership;
    }

    @Override
    public IDiscretization getClusterAssignment() {
        return this.voronoiDiscretization;
    }

    public String getDescriptiveName() {
        return "kmeans";
    }

    public IDoubleArray getClusterCenter(int i) {
        return this.clusterCenters.get(i);
    }

    @Override
    public int assign(IDoubleArray data) {
        return this.voronoiDiscretization.assign(data);
    }

    @Override
    public IDoubleArray getRepresentative(IDoubleArray p) {
        return this.clusterCenters.get(this.assign(p));
    }

    @Override
    public IDoubleArray assignFuzzy(IDoubleArray data) {
        return this.voronoiDiscretization.assignFuzzy(data);
    }

    @Override
    public Iterator<IDoubleArray> clusterCenterIterator() {
        return this.clusterCenters.iterator();
    }

    @Override
    public IIntArray getClusterIndexes() {
        this.assignments.trim();
        return Ints.create.arrayFrom(this.assignments.elements());
    }

    @Override
    public IDataSequence getClusterCenters() {
        return this.clusterCenters;
    }
}

