/*
 * Decompiled with CFR 0.152.
 */
package stallone.complex;

import stallone.api.complex.IComplexArray;
import stallone.api.complex.IComplexElement;
import stallone.api.complex.IComplexIterator;
import stallone.complex.ComplexArrayElement;

public class ComplexArrayIterator
implements IComplexIterator {
    protected ComplexArrayElement o;
    protected IComplexArray X;
    protected int i = 0;
    protected int j = 0;
    protected int rows;
    protected int cols;

    public ComplexArrayIterator(IComplexArray _X) {
        this.X = _X;
        this.rows = this.X.rows();
        this.cols = this.X.columns();
        this.o = new ComplexArrayElement(this.X, 0, 0);
    }

    @Override
    public void reset() {
        this.i = 0;
        this.j = 0;
    }

    @Override
    public boolean hasNext() {
        return this.i < this.rows && this.j < this.cols;
    }

    @Override
    public int row() {
        return this.i;
    }

    @Override
    public int column() {
        return this.j;
    }

    @Override
    public void advance() {
        if (this.j == this.cols - 1) {
            ++this.i;
            this.j = 0;
        } else {
            ++this.j;
        }
    }

    @Override
    public double get() {
        return this.X.get(this.i, this.j);
    }

    @Override
    public void set(double newValue) {
        this.X.set(this.i, this.j, newValue);
    }

    @Override
    public IComplexElement next() {
        this.o.setIndex(this.i, this.j);
        this.advance();
        return this.o;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported.");
    }

    @Override
    public int getIndex() {
        return this.i * this.cols + this.j;
    }

    @Override
    public double getRe() {
        return this.X.getRe(this.i, this.j);
    }

    @Override
    public double getIm() {
        return this.X.getIm(this.i, this.j);
    }

    @Override
    public void set(double re, double im) {
        this.X.set(this.i, this.j, re, im);
    }

    @Override
    public void setRe(double x) {
        this.X.setRe(this.i, this.j, x);
    }

    @Override
    public void setIm(double x) {
        this.X.setIm(this.i, this.j, x);
    }
}

