/*
 * Decompiled with CFR 0.152.
 */
package stallone.complex.io;

import stallone.api.algebra.IComplexNumber;
import stallone.api.complex.IComplexArray;

public class OutputUtil {
    public static String scalarToEasyString(IComplexNumber s) {
        return OutputUtil.scalarToEasyString(s.getRe(), s.getIm());
    }

    public static String scalarToEasyString(double re, double im) {
        if (im == 0.0) {
            return Double.toString(re);
        }
        if (im > 0.0) {
            return String.valueOf(Double.toString(re)) + "+" + im + "i";
        }
        return String.valueOf(Double.toString(re)) + im + "i";
    }

    public static String vectorToEasyString(IComplexArray v) {
        StringBuilder builder = new StringBuilder();
        int n = v.size();
        int i = 0;
        while (i < n) {
            builder.append(OutputUtil.scalarToEasyString(v.getRe(i), v.getIm(i)));
            if (i < n - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }
}

