/*
 * Decompiled with CFR 0.152.
 */
package stallone.coordinates;

import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IMetric;

public class MinimalRMSDistance3D
implements IMetric<IDoubleArray> {
    public static final int DIM = 3;
    public static final int MAX_ITERATIONS = 1000;
    public static final double TOLERANCE = 1.0E-7;
    private double[][] M;
    private double[][] K;
    private double[] p_centroid_k;
    private double[][] x_nk;
    private double[][] y_nk;
    private int N;

    public MinimalRMSDistance3D(int N) {
        this.N = N;
        this.M = new double[3][3];
        this.K = new double[4][4];
        this.p_centroid_k = new double[3];
        this.x_nk = new double[N][3];
        this.y_nk = new double[N][3];
    }

    public int getN() {
        return this.N;
    }

    protected double calculateMinRMSD() {
        int j;
        double G_x = 0.0;
        double G_y = 0.0;
        int i = 0;
        while (i < this.N) {
            j = 0;
            while (j < 3) {
                G_x += this.x_nk[i][j] * this.x_nk[i][j];
                G_y += this.y_nk[i][j] * this.y_nk[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                this.M[i][j] = 0.0;
                int k = 0;
                while (k < this.N) {
                    double[] dArray = this.M[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.x_nk[k][i] * this.y_nk[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.K[0][0] = this.M[0][0] + this.M[1][1] + this.M[2][2];
        this.K[0][1] = this.M[1][2] - this.M[2][1];
        this.K[0][2] = this.M[2][0] - this.M[0][2];
        this.K[0][3] = this.M[0][1] - this.M[1][0];
        this.K[1][0] = this.K[0][1];
        this.K[1][1] = this.M[0][0] - this.M[1][1] - this.M[2][2];
        this.K[1][2] = this.M[0][1] + this.M[1][0];
        this.K[1][3] = this.M[2][0] + this.M[0][2];
        this.K[2][0] = this.K[0][2];
        this.K[2][1] = this.K[1][2];
        this.K[2][2] = -this.M[0][0] + this.M[1][1] - this.M[2][2];
        this.K[2][3] = this.M[1][2] + this.M[2][1];
        this.K[3][0] = this.K[0][3];
        this.K[3][1] = this.K[1][3];
        this.K[3][2] = this.K[2][3];
        this.K[3][3] = -this.M[0][0] - this.M[1][1] + this.M[2][2];
        double C_4 = 1.0;
        double C_3 = 0.0;
        double C_2 = 0.0;
        int i2 = 0;
        while (i2 < 3) {
            int j2 = 0;
            while (j2 < 3) {
                C_2 -= 2.0 * this.M[i2][j2] * this.M[i2][j2];
                ++j2;
            }
            ++i2;
        }
        double C_1 = -8.0 * MinimalRMSDistance3D.det(this.M);
        double C_0 = MinimalRMSDistance3D.det(this.K);
        double lambda = (G_x + G_y) / 2.0;
        int i3 = 0;
        while (i3 < 1000) {
            double lambda_old = lambda;
            double lambda2 = lambda_old * lambda_old;
            double b = (lambda2 + C_2) * lambda_old;
            double a = b + C_1;
            if (Math.abs((lambda = lambda_old - (a * lambda_old + C_0) / (2.0 * lambda2 * lambda_old + b + a)) - lambda_old) < Math.abs(1.0E-7 * lambda)) break;
            ++i3;
        }
        double rmsd2 = (G_x + G_y - 2.0 * lambda) / (double)this.N;
        double result = 0.0;
        if (rmsd2 > 0.0) {
            result = Math.sqrt(rmsd2);
        }
        return result;
    }

    private void shiftToCentroid(double[][] p_orig_nk, double[][] p_shifted_nk) {
        int j = 0;
        while (j < 3) {
            this.p_centroid_k[j] = 0.0;
            int i = 0;
            while (i < this.N) {
                int n = j;
                this.p_centroid_k[n] = this.p_centroid_k[n] + p_orig_nk[i][j];
                ++i;
            }
            int n = j++;
            this.p_centroid_k[n] = this.p_centroid_k[n] / (double)this.N;
        }
        int i = 0;
        while (i < this.N) {
            int j2 = 0;
            while (j2 < 3) {
                p_shifted_nk[i][j2] = p_orig_nk[i][j2] - this.p_centroid_k[j2];
                ++j2;
            }
            ++i;
        }
    }

    public static double det(double[][] M) {
        int n = M.length;
        if (n == 1) {
            return M[0][0];
        }
        if (n == 2) {
            return M[0][0] * M[1][1] - M[0][1] * M[1][0];
        }
        if (n == 3) {
            return M[0][0] * (M[1][1] * M[2][2] - M[1][2] * M[2][1]) - M[1][0] * (M[0][1] * M[2][2] - M[0][2] * M[2][1]) + M[2][0] * (M[0][1] * M[1][2] - M[0][2] * M[1][1]);
        }
        if (n == 4) {
            return M[0][0] * (M[1][1] * (M[2][2] * M[3][3] - M[2][3] * M[3][2]) - M[2][1] * (M[1][2] * M[3][3] - M[1][3] * M[3][2]) + M[3][1] * (M[1][2] * M[2][3] - M[1][3] * M[2][2])) - M[1][0] * (M[0][1] * (M[2][2] * M[3][3] - M[2][3] * M[3][2]) - M[2][1] * (M[0][2] * M[3][3] - M[0][3] * M[3][2]) + M[3][1] * (M[0][2] * M[2][3] - M[0][3] * M[2][2])) + M[2][0] * (M[0][1] * (M[1][2] * M[3][3] - M[1][3] * M[3][2]) - M[1][1] * (M[0][2] * M[3][3] - M[0][3] * M[3][2]) + M[3][1] * (M[0][2] * M[1][3] - M[0][3] * M[1][2])) - M[3][0] * (M[0][1] * (M[1][2] * M[2][3] - M[1][3] * M[2][2]) - M[1][1] * (M[0][2] * M[2][3] - M[0][3] * M[2][2]) + M[2][1] * (M[0][2] * M[1][3] - M[0][3] * M[1][2]));
        }
        double result = 0.0;
        int i = 0;
        while (i < M[0].length) {
            double[][] temp = new double[M.length - 1][M[0].length - 1];
            int j = 1;
            while (j < M.length) {
                int k = 0;
                while (k < M[0].length) {
                    if (k < i) {
                        temp[j - 1][k] = M[j][k];
                    } else if (k > i) {
                        temp[j - 1][k - 1] = M[j][k];
                    }
                    ++k;
                }
                ++j;
            }
            result += M[0][i] * Math.pow(-1.0, i) * MinimalRMSDistance3D.det(temp);
            ++i;
        }
        return result;
    }

    private static double[][] convertFromFrame(IDoubleArray frame) {
        int n = frame.size() / 3;
        if (frame.size() % 3 != 0) {
            throw new RuntimeException("Critical error ..... length not dividable by 3.");
        }
        double[][] structure = new double[n][3];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < 3) {
                structure[i][j] = frame.get(i * 3 + j);
                ++j;
            }
            ++i;
        }
        return structure;
    }

    @Override
    public double distance(IDoubleArray p1, IDoubleArray p2) {
        if (p1.size() == p2.size()) {
            if (p1.rows() == this.N && p1.columns() == 3 && p2.rows() == this.N && p2.columns() == 3) {
                this.shiftToCentroid(p1.getTable(), this.x_nk);
                this.shiftToCentroid(p2.getTable(), this.y_nk);
                return this.calculateMinRMSD();
            }
            throw new RuntimeException("Wrong dimension. (" + this.N + " x " + 3 + ") expected, " + "but input vectors have (" + p1.rows() + " x " + p1.columns() + ") and (" + p2.rows() + " x " + p2.columns() + ").");
        }
        throw new RuntimeException("Can't calculate minRMSD, vectors do not have save length.");
    }
}

