/*
 * Decompiled with CFR 0.152.
 */
package stallone.coordinates;

import java.io.IOException;
import stallone.api.API;
import stallone.api.algebra.IEigenvalueDecomposition;
import stallone.api.coordinates.IPCA;
import stallone.api.datasequence.IDataInput;
import stallone.api.datasequence.IDataSequence;
import stallone.api.doubles.IDoubleArray;
import stallone.stat.RunningMomentsMultivariate;

public class PCA
implements IPCA {
    RunningMomentsMultivariate moments;
    private int dimIn;
    private IDoubleArray eval;
    private IDoubleArray evec;
    private int dimOut;

    public PCA(IDataInput _source) {
        this.init(_source.dimension());
        for (IDataSequence seq : _source.sequences()) {
            this.addData(seq);
        }
        this.computeTransform();
    }

    public PCA(IDataSequence _source) {
        this.init(_source.dimension());
        this.addData(_source);
        this.computeTransform();
    }

    public PCA() {
    }

    private final void init(int _dimIn) {
        this.dimIn = _dimIn;
        if (this.dimOut == 0) {
            this.dimOut = _dimIn;
        }
        this.moments = API.statNew.runningMomentsMultivar(this.dimIn);
    }

    @Override
    public final void addData(IDataSequence data) {
        if (this.dimIn == 0) {
            this.init(data.dimension());
        }
        this.moments.addData(data);
    }

    @Override
    public final void computeTransform() {
        IDoubleArray Cov = this.moments.getCov();
        IEigenvalueDecomposition evd = API.alg.evd(Cov);
        this.eval = evd.getEvalNorm();
        this.evec = evd.getRightEigenvectorMatrix().viewReal();
    }

    @Override
    public IDoubleArray getMeanVector() {
        return this.moments.getMean();
    }

    @Override
    public IDoubleArray getCovarianceMatrix() {
        return this.moments.getCov();
    }

    @Override
    public void setDimension(int d) {
        this.dimOut = d;
    }

    @Override
    public IDoubleArray getEigenvalues() {
        return this.eval;
    }

    @Override
    public IDoubleArray getEigenvector(int i) {
        return this.evec.viewColumn(i);
    }

    @Override
    public IDoubleArray getEigenvectorMatrix() {
        return this.evec;
    }

    @Override
    public IDoubleArray transform(IDoubleArray x) {
        IDoubleArray out = API.doublesNew.array(this.dimOut);
        this.transform(x, out);
        return out;
    }

    @Override
    public void transform(IDoubleArray in, IDoubleArray out) {
        IDoubleArray x;
        if (in.columns() != 1) {
            in = API.doublesNew.array(in.getArray());
        }
        if ((x = API.alg.subtract(in, this.moments.getMean())).rows() > 1) {
            x = API.alg.transposeToNew(x);
        }
        IDoubleArray y = API.alg.product(x, this.evec);
        int d = Math.min(in.size(), out.size());
        int i = 0;
        while (i < d) {
            out.set(i, y.get(i));
            ++i;
        }
    }

    @Override
    public int dimension() {
        return this.dimOut;
    }

    public static void main(String[] args) throws IOException {
        IDataInput dataInput = API.dataNew.dataInput("/Users/noe/data/software_projects/emma2/ipython/resources/Trypsin_Ca_dt1ns.dcd");
        PCA pca = new PCA(dataInput);
    }
}

