/*
 * Decompiled with CFR 0.152.
 */
package stallone.datasequence;

import java.util.Iterator;
import java.util.List;
import stallone.api.datasequence.IDataSequence;
import stallone.api.doubles.IDoubleArray;
import stallone.datasequence.DataSequenceIterator;
import stallone.datasequence.DataSequencePairIterator;

public class DataSequenceConcatenated
implements IDataSequence {
    protected List<IDataSequence> seqs;
    protected int totalsize;
    protected int dimension = -1;
    protected int[] microindex2trajindex;
    protected int[] microindex2localindex;

    protected DataSequenceConcatenated() {
    }

    public DataSequenceConcatenated(List<IDataSequence> _seqs) {
        this.seqs = _seqs;
        int i = 0;
        while (i < _seqs.size()) {
            this.totalsize += _seqs.get(i).size();
            if (this.dimension == -1) {
                this.dimension = _seqs.get(i).dimension();
            } else if (this.dimension != _seqs.get(i).dimension()) {
                throw new IllegalArgumentException("Data Sequence List has inconsistent dimensionality");
            }
            ++i;
        }
        this.microindex2trajindex = new int[this.totalsize];
        this.microindex2localindex = new int[this.totalsize];
        int k = 0;
        int i2 = 0;
        while (i2 < _seqs.size()) {
            int j = 0;
            while (j < _seqs.get(i2).size()) {
                this.microindex2trajindex[k] = i2;
                this.microindex2localindex[k] = j++;
                ++k;
            }
            ++i2;
        }
    }

    @Override
    public int size() {
        return this.totalsize;
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public double getTime(int i) {
        return this.seqs.get(this.microindex2trajindex[i]).getTime(this.microindex2localindex[i]);
    }

    @Override
    public IDoubleArray get(int i) {
        return this.seqs.get(this.microindex2trajindex[i]).get(this.microindex2localindex[i]);
    }

    @Override
    public IDoubleArray getView(int i) {
        return this.seqs.get(this.microindex2trajindex[i]).getView(this.microindex2localindex[i]);
    }

    @Override
    public Iterator<IDoubleArray> iterator() {
        return new DataSequenceIterator(this);
    }

    @Override
    public Iterator<IDoubleArray[]> pairIterator(int spacing) {
        return new DataSequencePairIterator(this, spacing);
    }

    @Override
    public Iterable<IDoubleArray[]> pairs(int spacing) {
        class PairIterable
        implements Iterable<IDoubleArray[]> {
            private IDataSequence seq;
            private int spacing = 1;

            public PairIterable(IDataSequence _seq, int _spacing) {
                this.seq = _seq;
                this.spacing = _spacing;
            }

            @Override
            public Iterator<IDoubleArray[]> iterator() {
                return new DataSequencePairIterator(this.seq, this.spacing);
            }
        }
        return new PairIterable(this, spacing);
    }
}

