/*
 * Decompiled with CFR 0.152.
 */
package stallone.datasequence;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import stallone.api.API;
import stallone.api.datasequence.IDataInput;
import stallone.api.datasequence.IDataReader;
import stallone.api.datasequence.IDataSequence;
import stallone.api.datasequence.IDataSequenceLoader;
import stallone.api.doubles.IDoubleArray;
import stallone.api.io.IO;
import stallone.datasequence.DataInput_DataPairIterable;
import stallone.datasequence.DataInput_SingleDataIterable;
import stallone.datasequence.DataInput_SingleSequenceIterable;

public class DataSequenceLoader_SingleReaderImpl
implements IDataSequenceLoader {
    private List<String> sources;
    private boolean scanned = false;
    private IDataReader reader;
    private int dimension = -1;
    private int currentSource;
    private boolean isOpen = false;
    private ArrayList<DataSequenceInfo> info = new ArrayList();
    private int totalSize = 0;
    private long largestMemorySize = 0L;
    private long totalMemorySize = 0L;

    public DataSequenceLoader_SingleReaderImpl(List<String> _sources, IDataReader _reader) throws IOException {
        this.sources = _sources;
        this.reader = _reader;
        if (this.sources == null) {
            throw new NullPointerException("List of sources provided to DataSequenceLoader is null. Cannot open input files.");
        }
        int i = 0;
        while (i < this.sources.size()) {
            if (!new File(this.sources.get(i)).exists()) {
                throw new IOException("Could not open file: " + this.sources.get(i));
            }
            this.info.add(new DataSequenceInfo());
            ++i;
        }
    }

    private void makeAvailable(int index) throws IOException {
        if (this.currentSource != index || !this.isOpen) {
            if (this.isOpen) {
                this.reader.close();
            }
            this.reader.setSource(this.sources.get(index));
            this.reader.open();
            this.isOpen = true;
            this.reader.scan();
            this.currentSource = index;
        }
    }

    @Override
    public void scan() throws IOException {
        this.info.clear();
        this.dimension = -1;
        int i = 0;
        while (i < this.sources.size()) {
            this.makeAvailable(i);
            DataSequenceInfo ds = new DataSequenceInfo();
            if (this.dimension == -1) {
                this.dimension = this.reader.dimension();
            } else if (this.dimension != this.reader.dimension()) {
                throw new IOException("Input files have inconsistent dimension: " + this.sources.get(i) + " has dimension " + this.reader.dimension() + ", while dimension " + this.dimension + " was set be the file(s) read earlier.");
            }
            ds.memorySize = this.reader.memorySize();
            ds.size = this.reader.size();
            this.info.add(ds);
            this.totalSize += ds.size;
            if (ds.memorySize > this.largestMemorySize) {
                this.largestMemorySize = ds.memorySize;
            }
            this.totalMemorySize += ds.memorySize;
            ++i;
        }
        this.scanned = true;
    }

    @Override
    public int numberOfSequences() {
        return this.sources.size();
    }

    @Override
    public int dimension() {
        if (this.dimension == -1) {
            try {
                this.makeAvailable(0);
            }
            catch (IOException e) {
                IO.util.error("Exception while trying to open trajectory " + this.sources.get(0) + ":\n" + e);
            }
            this.dimension = this.reader.dimension();
        }
        return this.dimension;
    }

    @Override
    public int size() {
        if (!this.scanned) {
            IO.util.error("Need to call scan() first before requesting information from a DataSequenceLoader.");
        }
        return this.totalSize;
    }

    @Override
    public int size(int trajIndex) {
        if (!this.scanned) {
            try {
                this.makeAvailable(trajIndex);
                this.info.get((int)trajIndex).size = this.reader.size();
                this.info.get((int)trajIndex).memorySize = this.reader.memorySize();
            }
            catch (IOException e) {
                IO.util.error("Exception while trying to open trajectory " + this.sources.get(0) + ":\n" + e);
            }
            this.dimension = this.reader.dimension();
        }
        return this.info.get((int)trajIndex).size;
    }

    @Override
    public long memorySizeOfSingleSequence(int trajIndex) {
        if (!this.scanned) {
            try {
                this.makeAvailable(trajIndex);
                this.info.get((int)trajIndex).size = this.reader.size();
                this.info.get((int)trajIndex).memorySize = this.reader.memorySize();
            }
            catch (IOException e) {
                IO.util.error("Exception while trying to open trajectory " + this.sources.get(0) + ":\n" + e);
            }
            this.dimension = this.reader.dimension();
        }
        return this.info.get((int)trajIndex).memorySize;
    }

    @Override
    public long memorySizeOfLargestSequence() {
        if (!this.scanned) {
            IO.util.error("Need to call scan() first before requesting information from a DataSequenceLoader.");
        }
        return this.largestMemorySize;
    }

    @Override
    public long memorySizeTotal() {
        if (!this.scanned) {
            IO.util.error("Need to call scan() first before requesting information from a DataSequenceLoader.");
        }
        return this.totalMemorySize;
    }

    @Override
    public Iterable<IDoubleArray> singles() {
        return new DataInput_SingleDataIterable(this);
    }

    @Override
    public Iterable<IDoubleArray[]> pairs(int spacing) {
        return new DataInput_DataPairIterable(this, spacing);
    }

    @Override
    public Iterable<IDataSequence> sequences() {
        return new DataInput_SingleSequenceIterable(this);
    }

    @Override
    public IDoubleArray get(int sequenceIndex, int frameIndex) {
        try {
            this.makeAvailable(sequenceIndex);
        }
        catch (IOException ex) {
            Logger.getLogger(DataSequenceLoader_SingleReaderImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.reader.get(frameIndex);
    }

    @Override
    public IDataSequence getSequence(int sequenceIndex) {
        try {
            this.makeAvailable(sequenceIndex);
        }
        catch (IOException ex) {
            Logger.getLogger(DataSequenceLoader_SingleReaderImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.reader;
    }

    @Override
    public IDataSequence loadSequence(int sequenceIndex) {
        try {
            this.makeAvailable(sequenceIndex);
        }
        catch (IOException ex) {
            Logger.getLogger(DataSequenceLoader_SingleReaderImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.reader.load();
    }

    @Override
    public IDataInput loadAll() {
        ArrayList<IDataSequence> res = new ArrayList<IDataSequence>();
        int i = 0;
        while (i < this.sources.size()) {
            try {
                this.makeAvailable(i);
            }
            catch (IOException ex) {
                Logger.getLogger(DataSequenceLoader_SingleReaderImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            res.add(this.reader.load());
            ++i;
        }
        IDataInput ret = null;
        try {
            ret = API.dataNew.dataInput(res);
        }
        catch (IOException ex) {
            Logger.getLogger(DataSequenceLoader_SingleReaderImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        return ret;
    }

    class DataSequenceInfo {
        protected int size;
        protected long memorySize;

        DataSequenceInfo() {
        }
    }
}

