/*
 * Decompiled with CFR 0.152.
 */
package stallone.datasequence.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import stallone.api.datasequence.DataSequence;
import stallone.api.datasequence.IDataList;
import stallone.api.datasequence.IDataReader;
import stallone.api.datasequence.IDataSequence;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.datasequence.io.DataReaderIterator;
import stallone.datasequence.io.DataReaderPairIterator;
import stallone.ints.PrimitiveIntTools;
import stallone.io.CachedAsciiFileReader;
import stallone.util.StringTools;

public class AsciiDataSequenceReader
extends CachedAsciiFileReader
implements IDataReader {
    private int dimension = 0;
    private int dataStartLine = 0;
    private int timeColumn = -1;
    private int[] selectedColumns = null;

    public AsciiDataSequenceReader(String filename) throws FileNotFoundException, IOException {
        super(filename);
    }

    public AsciiDataSequenceReader(String filename, int _dataStartLine, int _timeColumn, int[] _selectedColumns) throws FileNotFoundException, IOException {
        super(filename);
        this.dataStartLine = _dataStartLine;
        this.timeColumn = _timeColumn;
        this.selectedColumns = _selectedColumns;
    }

    @Override
    protected boolean scanLine(String textline, int currentLineNumber) {
        if (this.selectedColumns == null) {
            try {
                double[] dline = StringTools.toDoubleArray(textline);
                this.dimension = dline.length;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        String[] words = StringTools.split(textline);
        words = StringTools.subarray(words, this.selectedColumns);
        int i = 0;
        while (i < words.length) {
            if (!StringTools.isDouble(words[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String[] readTokens(int lineNumber) {
        if (lineNumber >= 0 && lineNumber < this.size()) {
            String currentLine = super.getLine(this.dataStartLine + lineNumber);
            String[] elements = CachedAsciiFileReader.whiteSpacePattern.split(currentLine.trim());
            return elements;
        }
        throw new IllegalArgumentException("Invalid line " + lineNumber + " requested.");
    }

    @Override
    public void setSource(String name) {
        super.setFilename(name);
    }

    @Override
    public int size() {
        return this.getNumberOfLines();
    }

    @Override
    public int dimension() {
        if (this.selectedColumns != null) {
            return this.selectedColumns.length;
        }
        return this.dimension;
    }

    @Override
    public long memorySize() {
        return 8 * this.size() * this.dimension();
    }

    @Override
    public double getTime(int frameIndex) {
        if (this.timeColumn == -1) {
            return frameIndex;
        }
        String[] entries = this.readTokens(frameIndex);
        double value = 0.0;
        try {
            value = Double.parseDouble(entries[this.timeColumn]);
        }
        catch (NumberFormatException nfe) {
            System.out.println("frameIndex : " + frameIndex);
        }
        return value;
    }

    @Override
    public void select(int[] selection) {
        this.selectedColumns = selection;
    }

    @Override
    public int[] getSelection() {
        if (this.selectedColumns == null) {
            return PrimitiveIntTools.range(this.dimension());
        }
        return this.selectedColumns;
    }

    @Override
    public IDoubleArray get(int index) {
        return this.get(index, null);
    }

    @Override
    public IDoubleArray getView(int index) {
        return this.get(index);
    }

    public IDoubleArray get(int frameIndex, IDoubleArray target) {
        String[] entries = this.readTokens(frameIndex);
        if (target == null) {
            target = this.selectedColumns == null ? Doubles.create.array(entries.length) : Doubles.create.array(this.selectedColumns.length);
        }
        try {
            if (this.selectedColumns == null) {
                int i = 0;
                while (i < entries.length) {
                    double value = Double.parseDouble(entries[i]);
                    target.set(i, value);
                    ++i;
                }
            } else {
                int n = this.selectedColumns.length;
                int i = 0;
                while (i < n) {
                    double value = Double.parseDouble(entries[this.selectedColumns[i]]);
                    target.set(i, value);
                    ++i;
                }
            }
        }
        catch (NumberFormatException nfe) {
            System.out.println("nfe frameIndex : " + frameIndex + "exe detail:" + nfe);
        }
        return target;
    }

    @Override
    public IDataSequence load() {
        IDataList res = DataSequence.create.list();
        Iterator<IDoubleArray> it = this.iterator();
        while (it.hasNext()) {
            res.add(it.next());
        }
        return res;
    }

    @Override
    public Iterator<IDoubleArray> iterator() {
        return new DataReaderIterator(this);
    }

    @Override
    public Iterator<IDoubleArray[]> pairIterator(int spacing) {
        return new DataReaderPairIterator(this, spacing);
    }

    @Override
    public Iterable<IDoubleArray[]> pairs(int spacing) {
        class PairIterable
        implements Iterable<IDoubleArray[]> {
            private IDataReader seq;
            private int spacing = 1;

            public PairIterable(IDataReader _seq, int _spacing) {
                this.seq = _seq;
                this.spacing = _spacing;
            }

            @Override
            public Iterator<IDoubleArray[]> iterator() {
                return new DataReaderPairIterator(this.seq, this.spacing);
            }
        }
        return new PairIterable(this, spacing);
    }
}

