/*
 * Decompiled with CFR 0.152.
 */
package stallone.datasequence.io;

import java.io.IOException;
import java.util.Iterator;
import stallone.api.datasequence.IDataReader;
import stallone.api.doubles.IDoubleArray;

public class DataReaderPairIterator
implements Iterator<IDoubleArray[]> {
    private IDataReader reader = null;
    private IDoubleArray[] pair = new IDoubleArray[2];
    private int spacing = 1;
    private int i1 = 0;
    private int i2 = 1;

    public DataReaderPairIterator(IDataReader _reader, int _spacing) {
        this.reader = _reader;
        this.openThisReader(this.reader);
        this.spacing = _spacing;
        this.i1 = 0;
        this.i2 = _spacing;
    }

    private void openThisReader(IDataReader _reader) {
        try {
            _reader.open();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException during Trajectory iteration: " + e);
        }
    }

    private void closeThisReader(IDataReader _reader) {
        try {
            _reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException during Trajectory iteration: " + e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.i2 < this.reader.size();
    }

    @Override
    public IDoubleArray[] next() {
        this.pair[0] = this.reader.get(this.i1);
        this.pair[1] = this.reader.get(this.i2);
        ++this.i1;
        ++this.i2;
        return this.pair;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported.");
    }

    protected void finalize() throws Throwable {
        this.closeThisReader(this.reader);
        super.finalize();
    }
}

