/*
 * Decompiled with CFR 0.152.
 */
package stallone.datasequence.io;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import stallone.api.datasequence.IDataWriter;
import stallone.api.doubles.IDoubleArray;

public class DcdWriter
implements IDataWriter {
    private OutputStream stream = null;
    private final int nDimension;
    private final int nFrames;
    private int framesWritten;
    private ByteBuffer bb;

    public DcdWriter(String filename, int _nFrames, int _nDimensions) {
        try {
            this.stream = new BufferedOutputStream(new FileOutputStream(filename));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DcdWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.nFrames = _nFrames;
        this.nDimension = _nDimensions;
        this.framesWritten = 0;
        if (_nDimensions % 3 != 0) {
            throw new IllegalArgumentException("Dimension of trajectory must be dividable by 3.");
        }
        this.writeHeader(this.nFrames, _nDimensions);
    }

    private void writeHeader(int nFrames, int nDimensions) {
        try {
            int startStep = 1;
            int freqSaving = 1;
            byte[] bytes = new byte[276];
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            bb.putInt(84);
            bb.put("CORD".getBytes());
            bb.putInt(nFrames);
            bb.putInt(startStep);
            bb.putInt(freqSaving);
            int i = 0;
            while (i < 17) {
                bb.putInt(0);
                ++i;
            }
            bb.putInt(84);
            bb.putInt(164);
            bb.putInt(2);
            i = 0;
            while (i < 80) {
                bb.put((byte)0);
                ++i;
            }
            i = 0;
            while (i < 80) {
                bb.put((byte)0);
                ++i;
            }
            bb.putInt(164);
            bb.putInt(4);
            bb.putInt(nDimensions / 3);
            bb.putInt(4);
            this.stream.write(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public void add(IDoubleArray v) {
        try {
            int n = v.size();
            if (n % 3 != 0) {
                throw new IllegalArgumentException("Vector has not a dimension, which is dividable by 3. Can not write out.");
            }
            int numberOfAtoms = n / 3;
            int nbytes = 24 + 12 * numberOfAtoms;
            if (this.bb == null || this.bb.capacity() < nbytes) {
                this.bb = ByteBuffer.wrap(new byte[nbytes]);
                this.bb.order(ByteOrder.LITTLE_ENDIAN);
            }
            this.bb.clear();
            int d = 0;
            while (d < 3) {
                int chunksize = 4 * numberOfAtoms;
                this.bb.putInt(chunksize);
                int a = 0;
                while (a < numberOfAtoms) {
                    int idx = a * 3 + d;
                    this.bb.putFloat((float)v.get(idx));
                    ++a;
                }
                this.bb.putInt(chunksize);
                ++d;
            }
            this.stream.write(this.bb.array(), 0, nbytes);
            ++this.framesWritten;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public void addAll(Iterable<IDoubleArray> data) {
        for (IDoubleArray d : data) {
            this.add(d);
        }
    }

    @Override
    public void close() {
        try {
            this.stream.close();
            if (this.framesWritten != this.nFrames) {
                throw new IllegalStateException("Number of written frames does not match number of specified frames.(" + this.framesWritten + " written|" + this.nFrames + " specified).");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

