/*
 * Decompiled with CFR 0.152.
 */
package stallone.discretization;

import java.util.Iterator;
import stallone.api.API;
import stallone.api.datasequence.IDataSequence;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.function.IGrid;
import stallone.api.ints.IIntArray;
import stallone.datasequence.DataSequenceResizable;
import stallone.discretization.GridPointIterator;
import stallone.doubles.DoubleArrayView;
import stallone.ints.IntArrayView;
import stallone.ints.PrimitiveIntArray;
import stallone.ints.PrimitiveIntTable;

public class Grid
implements IGrid {
    private int dim;
    private double[] left;
    private double[] step;
    private double[] right;
    private double[] width;
    private IDoubleArray[] pointPositions;
    private int[] sizes;
    private int[] numbers;
    private IntArrayView preNeighborIndexes;
    private IntArrayView preMultIndex;
    private DoubleArrayView prePoint;
    private IntArrayView preNeighborMultIndexes;
    private DataSequenceResizable preNeighbors;
    private int[] multIndex;

    public Grid(IDoubleArray griddef) {
        this.init(griddef);
    }

    public Grid(IDoubleArray bounds, double _step) {
        IDoubleArray griddef = API.doublesNew.matrix(bounds.rows(), 3);
        int i = 0;
        while (i < griddef.rows()) {
            griddef.set(i, 0, bounds.get(i, 0));
            griddef.set(i, 1, _step);
            griddef.set(i, 2, bounds.get(i, 1));
            ++i;
        }
        this.init(griddef);
    }

    private void init(IDoubleArray griddef) {
        this.dim = griddef.rows();
        this.left = new double[this.dim];
        this.step = new double[this.dim];
        this.right = new double[this.dim];
        this.width = new double[this.dim];
        this.pointPositions = new IDoubleArray[this.dim];
        this.sizes = new int[this.dim];
        this.numbers = new int[this.dim];
        this.multIndex = new int[this.dim];
        int i = 0;
        while (i < this.dim) {
            this.left[i] = griddef.get(i, 0);
            this.step[i] = griddef.get(i, 1);
            this.right[i] = griddef.get(i, 2);
            this.width[i] = this.right[i] - this.left[i];
            this.pointPositions[i] = Doubles.create.arrayRange(this.left[i] + this.step[i] / 2.0, this.right[i] - this.step[i] / 2.0 + 1.0E-6 * this.step[i], this.step[i]);
            this.sizes[i] = this.pointPositions[i].size();
            ++i;
        }
        this.numbers[this.dim - 1] = 1;
        i = this.dim - 2;
        while (i >= 0) {
            this.numbers[i] = this.numbers[i + 1] * this.sizes[i];
            --i;
        }
        this.preNeighborIndexes = new IntArrayView(new PrimitiveIntArray(this.dim * 2), 0, this.dim * 2);
        this.preMultIndex = new IntArrayView(new PrimitiveIntArray(this.dim), 0, this.dim);
        this.prePoint = new DoubleArrayView(API.doublesNew.array(this.dim), 0, this.dim);
        this.preNeighborMultIndexes = new IntArrayView(new PrimitiveIntTable(this.dim * 2, this.dim), 0, 0, this.dim * 2, this.dim);
    }

    @Override
    public int getNumberOfGridPoints() {
        int n = 1;
        int i = 0;
        while (i < this.pointPositions.length) {
            n *= this.pointPositions[i].size();
            ++i;
        }
        return n;
    }

    @Override
    public int getNumberOfGridPoints(int dimension) {
        return this.pointPositions[dimension].size();
    }

    private int[] getMultiIndex(int index) {
        int rest = index;
        int i = 0;
        while (i < this.multIndex.length) {
            this.multIndex[i] = rest / this.numbers[i];
            rest %= this.numbers[i];
            ++i;
        }
        return this.multIndex;
    }

    @Override
    public int getIndex(int ... indexes) {
        int res = 0;
        int i = 0;
        while (i < this.multIndex.length) {
            res += indexes[i] * this.numbers[i];
            ++i;
        }
        return res;
    }

    @Override
    public int getIndex(IIntArray indexes) {
        return this.getIndex(indexes.getArray());
    }

    @Override
    public IDoubleArray getPoint(IIntArray indexes) {
        int i = 0;
        while (i < indexes.size()) {
            this.prePoint.set(i, this.pointPositions[i].get(indexes.get(i)));
            ++i;
        }
        return this.prePoint;
    }

    @Override
    public IDoubleArray getPoint(int ... indexes) {
        int i = 0;
        while (i < indexes.length) {
            this.prePoint.set(i, this.pointPositions[i].get(indexes[i]));
            ++i;
        }
        return this.prePoint;
    }

    @Override
    public IIntArray nearestMultiIndex(IDoubleArray x) {
        int size = x.size();
        int i = 0;
        while (i < size) {
            double xc = x.get(i);
            int ic = (int)((xc - this.left[i]) / this.step[i]);
            if (ic < 0) {
                ic = 0;
            }
            if (ic > this.sizes[i] - 1) {
                ic = this.sizes[i] - 1;
            }
            this.preMultIndex.set(i, ic);
            ++i;
        }
        return this.preMultIndex;
    }

    @Override
    public int assign(IDoubleArray x) {
        return this.getIndex(this.nearestMultiIndex(x));
    }

    @Override
    public IDoubleArray getRepresentative(IDoubleArray x) {
        return this.getPoint(this.nearestMultiIndex(x));
    }

    @Override
    public IDoubleArray assignFuzzy(IDoubleArray x) {
        IDoubleArray res = Doubles.create.sparseColumn(this.size());
        res.set(this.assign(x), 1.0);
        return res;
    }

    @Override
    public int size() {
        int res = 1;
        int i = 0;
        while (i < this.sizes.length) {
            res *= this.sizes[i];
            ++i;
        }
        return res;
    }

    @Override
    public int dimension() {
        return this.dim;
    }

    @Override
    public IDoubleArray get(int i) {
        return this.getPoint(this.getMultiIndex(i));
    }

    @Override
    public IDoubleArray getView(int i) {
        return this.get(i);
    }

    @Override
    public Iterator<IDoubleArray> iterator() {
        return new GridPointIterator(this.sizes, this.pointPositions);
    }

    @Override
    public IIntArray getNeighborIndexes(int index) {
        IIntArray neighborMultiIndexes = this.getNeighborMultiIndexes(this.getMultiIndex(index));
        this.preNeighborIndexes.setView(0, neighborMultiIndexes.rows());
        int i = 0;
        while (i < neighborMultiIndexes.rows()) {
            this.preNeighborIndexes.set(i, this.getIndex(neighborMultiIndexes.getRow(i)));
            ++i;
        }
        return this.preNeighborIndexes;
    }

    @Override
    public IIntArray getNeighborMultiIndexes(int ... indexes) {
        int nneighbors = 0;
        int i = 0;
        while (i < this.dim) {
            int j;
            if (indexes[i] > 0) {
                int n = i;
                indexes[n] = indexes[n] - 1;
                j = 0;
                while (j < this.dim) {
                    this.preNeighborMultIndexes.set(nneighbors, j, indexes[j]);
                    ++j;
                }
                ++nneighbors;
                int n2 = i;
                indexes[n2] = indexes[n2] + 1;
            }
            if (indexes[i] < this.sizes[i] - 1) {
                int n = i;
                indexes[n] = indexes[n] + 1;
                j = 0;
                while (j < this.dim) {
                    this.preNeighborMultIndexes.set(nneighbors, j, indexes[j]);
                    ++j;
                }
                ++nneighbors;
                int n3 = i;
                indexes[n3] = indexes[n3] - 1;
            }
            ++i;
        }
        this.preNeighborMultIndexes.setView(0, 0, nneighbors, this.dim);
        return this.preNeighborMultIndexes;
    }

    @Override
    public IDataSequence getNeighbors(int index) {
        IIntArray neighborMultiIndexes = this.getNeighborMultiIndexes(this.getMultiIndex(index));
        this.preNeighbors.setSize(neighborMultiIndexes.size());
        int i = 0;
        while (i < this.preNeighbors.size()) {
            this.preNeighbors.set(i, this.getPoint(neighborMultiIndexes.get(i)));
            ++i;
        }
        return this.preNeighbors;
    }

    @Override
    public double getTime(int i) {
        return i;
    }

    @Override
    public Iterator<IDoubleArray[]> pairIterator(int spacing) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Iterable<IDoubleArray[]> pairs(int spacing) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

