/*
 * Decompiled with CFR 0.152.
 */
package stallone.discretization;

import java.util.Iterator;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.ints.IIntArray;
import stallone.api.ints.Ints;
import stallone.util.Counter;

class GridPointIterator
implements Iterator<IDoubleArray> {
    Counter count;
    boolean overflow = false;
    IDoubleArray[] pointPositions;
    int dim;
    IDoubleArray prePoint;

    public GridPointIterator(int[] sizes, IDoubleArray[] pointPositions) {
        this.count = new Counter(Ints.create.arrayFrom(sizes));
        this.dim = sizes.length;
        this.prePoint = Doubles.create.array(sizes.length);
    }

    @Override
    public boolean hasNext() {
        return !this.overflow;
    }

    @Override
    public IDoubleArray next() {
        IIntArray c = this.count.get();
        int i = 0;
        while (i < this.dim) {
            this.prePoint.set(i, this.pointPositions[i].get(c.get(i)));
            ++i;
        }
        this.overflow = this.count.inc();
        return this.prePoint;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

