/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import stallone.api.doubles.IDoubleArray;
import stallone.doubles.AbstractDoubleArray;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class ForeignBufferDoubleArray
extends AbstractDoubleArray
implements IDoubleArray {
    private DoubleBuffer buff;
    private int rows;
    private int cols;

    private ForeignBufferDoubleArray() {
    }

    public ForeignBufferDoubleArray(ByteBuffer bb, int rows, int cols) {
        if (bb.capacity() / 64 < rows * cols / 64) {
            throw new OutOfMemoryError("byte buffer does not hold enough memory (" + bb.capacity() / 64 + ") to store " + rows * cols + " elements.");
        }
        bb.order();
        bb.order(ByteOrder.nativeOrder());
        this.buff = bb.asDoubleBuffer();
        this.rows = rows;
        this.cols = cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public int columns() {
        return this.cols;
    }

    @Override
    public double get(int i, int j) {
        try {
            if (this.cols == 1 && j == 0) {
                return this.buff.get(i);
            }
            if (this.rows == 1 && i == 0) {
                return this.buff.get(j);
            }
            return this.buff.get(i * this.cols + j);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Array index error:Trying to access element (" + i + "," + j + ") in a (" + this.rows + "," + this.cols + ") array");
        }
    }

    @Override
    public void set(int i, int j, double x) {
        try {
            if (this.cols == 1 && j == 0) {
                this.buff.put(i, x);
            } else if (this.rows == 1 && i == 0) {
                this.buff.put(j, x);
            } else {
                int index = i * this.cols + j;
                assert (i <= this.rows && j <= this.cols);
                assert (index % 64 == 0);
                this.buff.put(index, x);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Array index error:Trying to access element (" + i + "," + j + ") in a (" + this.rows + "," + this.cols + ") array");
        }
    }

    @Override
    public IDoubleArray copy() {
        Unsafe unsafe;
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            Method m = Unsafe.class.getDeclaredMethod("copyMemory", new Class[0]);
            f.setAccessible(true);
            m.setAccessible(true);
            unsafe = (Unsafe)f.get(null);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        ByteBuffer clone = ByteBuffer.allocateDirect(this.buff.capacity());
        long src = ((DirectBuffer)((Object)this.buff)).address();
        long dst = ((DirectBuffer)((Object)clone)).address();
        unsafe.copyMemory(src, dst, this.buff.capacity());
        return new ForeignBufferDoubleArray(clone, this.rows, this.cols);
    }

    @Override
    public IDoubleArray create(int size) {
        ByteBuffer bb = ByteBuffer.allocateDirect(size * 64);
        ForeignBufferDoubleArray da = new ForeignBufferDoubleArray(bb, 1, size);
        return da;
    }

    @Override
    public IDoubleArray create(int rows, int columns) {
        ByteBuffer bb = ByteBuffer.allocateDirect(64 * rows * columns);
        ForeignBufferDoubleArray da = new ForeignBufferDoubleArray(bb, rows, columns);
        return da;
    }

    @Override
    public boolean isSparse() {
        return false;
    }
}

