/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles;

import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleIterator;
import stallone.doubles.AbstractDoubleArray;
import stallone.doubles.SparseRealMatrixNonzeroIterator;
import stallone.doubles.SparseRealVector;

public class SparseRealMatrix
extends AbstractDoubleArray {
    protected SparseRealVector[] rowVectors;
    protected int rows;
    protected int cols;

    public SparseRealMatrix(int _rows, int _cols) {
        this.rows = _rows;
        this.cols = _cols;
        this.rowVectors = new SparseRealVector[this.rows];
        int i = 0;
        while (i < this.rows) {
            this.rowVectors[i] = new SparseRealVector(this.cols);
            ++i;
        }
    }

    private SparseRealMatrix(SparseRealMatrix source) {
        this.rows = source.rows;
        this.cols = source.cols;
        this.rowVectors = new SparseRealVector[this.rows];
        int i = 0;
        while (i < this.rows) {
            this.rowVectors[i] = (SparseRealVector)source.rowVectors[i].copy();
            ++i;
        }
    }

    @Override
    public void zero() {
        int i = 0;
        while (i < this.rows) {
            this.rowVectors[i].zero();
            ++i;
        }
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public int columns() {
        return this.cols;
    }

    @Override
    public double get(int i, int j) {
        return this.rowVectors[i].get(j);
    }

    @Override
    public void set(int i, int j, double real) {
        this.rowVectors[i].set(j, real);
    }

    @Override
    public void copyFrom(IDoubleArray source) {
        this.zero();
        IDoubleIterator it = source.nonzeroIterator();
        while (it.hasNext()) {
            this.set(it.row(), it.column(), it.get());
            it.advance();
        }
    }

    @Override
    public void copyInto(IDoubleArray target) {
        target.zero();
        IDoubleIterator it = this.nonzeroIterator();
        while (it.hasNext()) {
            target.set(it.row(), it.column(), it.get());
            it.advance();
        }
    }

    @Override
    public IDoubleArray copy() {
        return new SparseRealMatrix(this);
    }

    @Override
    public IDoubleArray create(int rows, int cols) {
        return new SparseRealMatrix(rows, cols);
    }

    @Override
    public IDoubleArray create(int size) {
        return new SparseRealMatrix(this.rows, 1);
    }

    @Override
    public IDoubleArray viewRow(int r) {
        return this.rowVectors[r];
    }

    @Override
    public boolean isSparse() {
        return true;
    }

    @Override
    public IDoubleIterator nonzeroIterator() {
        return new SparseRealMatrixNonzeroIterator(this);
    }
}

