/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.regex.Pattern;
import stallone.api.doubles.Doubles;
import stallone.doubles.io.AbstractAsciiMatrixReader;

public class SparseDoubleArrayAsciiReader
extends AbstractAsciiMatrixReader {
    private Pattern sparseHeader = Pattern.compile("SPARSE\\s+[0-9]+\\s+[0-9]+\\s*");

    public SparseDoubleArrayAsciiReader(String filename) throws FileNotFoundException, IOException {
        super(filename);
    }

    @Override
    public boolean checkHeader() {
        return this.sparseHeader.matcher(this.getLine(0)).matches();
    }

    @Override
    protected void readToMatrix() {
        String[] elements;
        int numberOfRows = 0;
        int numberOfColumns = 0;
        String headerLine = this.getLine(0);
        if (this.sparseHeader.matcher(headerLine).matches()) {
            elements = whiteSpacePattern.split(headerLine);
            if (elements.length != 3) {
                throw new RuntimeException("Invalid header for sparse matrix, should be 'SPARSE <rows> <columns>'.");
            }
        } else {
            throw new RuntimeException("Invalid header found.");
        }
        numberOfRows = Integer.parseInt(elements[1]);
        numberOfColumns = Integer.parseInt(elements[2]);
        this.m = Doubles.create.sparseMatrix(numberOfRows, numberOfColumns);
        int i = this.getDataStart();
        int n = this.getDataEnd();
        while (i < n) {
            String currentLine = this.getLine(i);
            String[] elements2 = whiteSpacePattern.split(currentLine);
            int rowLength = elements2.length;
            if (rowLength != 3) {
                throw new RuntimeException("Expecting 3 entries per line: rowIndex columnIndex value.");
            }
            int rowIdx = Integer.parseInt(elements2[0]);
            int colIdx = Integer.parseInt(elements2[1]);
            double val = Double.parseDouble(elements2[2]);
            this.m.set(rowIdx, colIdx, val);
            ++i;
        }
        System.out.println("Sparse matrix with dimension ( " + numberOfRows + " x " + numberOfColumns + " ) " + "read successfully from file '" + this.filename + "'.");
    }
}

