/*
 * Decompiled with CFR 0.152.
 */
package stallone.dynamics;

import java.util.Random;
import stallone.api.doubles.IDoubleArray;
import stallone.api.dynamics.IIntegrator;
import stallone.api.dynamics.IIntegratorThermostatted;
import stallone.api.potential.IEnergyModel;

public class BrownianDynamicsEuler
implements IIntegratorThermostatted {
    private double dt = 0.0;
    private double gamma = 0.0;
    private double kT = 1.0;
    private IDoubleArray x;
    private IEnergyModel model;
    private IDoubleArray masses;
    private Random random = new Random();

    public BrownianDynamicsEuler(double _dt, double _gamma, double _kT) {
        this.dt = _dt;
        this.gamma = _gamma;
        this.kT = _kT;
    }

    @Override
    public IIntegrator copy() {
        BrownianDynamicsEuler res = new BrownianDynamicsEuler(this.dt, this.gamma, this.kT);
        res.setX(this.x.copy());
        res.setEnergyModel(this.model);
        res.setMasses(this.masses.copy());
        return res;
    }

    @Override
    public void setX(IDoubleArray x0) {
        this.x = x0.copy();
    }

    @Override
    public void setV(IDoubleArray v0) {
        throw new UnsupportedOperationException("Brownian Dynamics has no velocities.");
    }

    @Override
    public void setEnergyModel(IEnergyModel _model) {
        this.model = _model;
    }

    @Override
    public void setMasses(IDoubleArray _masses) {
        this.masses = _masses;
    }

    @Override
    public void setStepLength(double _dt) {
        this.dt = _dt;
    }

    @Override
    public boolean step() {
        this.model.setCoordinates(this.x);
        this.model.calculate();
        IDoubleArray grad = this.model.getGradient();
        int i = 0;
        while (i < this.x.size()) {
            double gm = this.gamma * this.masses.get(i);
            double r = this.random.nextGaussian();
            double dx = -this.dt * grad.get(i) / gm + Math.sqrt(2.0 * this.dt * this.kT / gm) * r;
            this.x.set(i, this.x.get(i) + dx);
            ++i;
        }
        return true;
    }

    @Override
    public IDoubleArray getX() {
        return this.x.copy();
    }

    @Override
    public IDoubleArray getV() {
        throw new UnsupportedOperationException("Brownian Dynamics has no velocities.");
    }

    @Override
    public IDoubleArray getA() {
        throw new UnsupportedOperationException("Brownian Dynamics has no accelerations.");
    }

    @Override
    public double getStepLength() {
        return this.dt;
    }

    @Override
    public double potentialEnergy() {
        return this.model.getEnergy();
    }

    @Override
    public double kineticEnergy() {
        throw new UnsupportedOperationException("Brownian Dynamics has no kinetic energy.");
    }

    @Override
    public double totalEnergy() {
        return this.model.getEnergy();
    }

    @Override
    public void setkT(double kT) {
        this.kT = kT;
    }

    @Override
    public double getkT() {
        return this.kT;
    }
}

