/*
 * Decompiled with CFR 0.152.
 */
package stallone.function;

import org.nfunk.jep.JEP;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.function.IFunctionC1;
import stallone.function.JEPFunction;

public class JEPFunctionC1
extends JEPFunction
implements IFunctionC1 {
    protected JEP[] gjep;
    private IDoubleArray grad;

    public JEPFunctionC1(String[] _variables, String _expression, String ... _derivatives) {
        super(_variables, _expression);
        if (this.variables.length != _derivatives.length) {
            throw new IllegalArgumentException("Number of derivatives must be identical to number of variables");
        }
        this.gjep = new JEP[this.variables.length];
        int i = 0;
        while (i < this.variables.length) {
            this.gjep[i] = new JEP();
            this.gjep[i].addStandardFunctions();
            this.gjep[i].addStandardConstants();
            String[] stringArray = this.variables;
            int n = this.variables.length;
            int n2 = 0;
            while (n2 < n) {
                String var = stringArray[n2];
                this.gjep[i].addVariable(var, 0.0);
                ++n2;
            }
            this.gjep[i].parseExpression(_derivatives[i]);
            ++i;
        }
        this.grad = Doubles.create.array(this.variables.length);
    }

    public JEPFunctionC1(String _expression, String ... _derivatives) {
        this((String[])null, _expression, _derivatives);
    }

    @Override
    public IDoubleArray grad(double ... x) {
        if (x.length != this.variables.length) {
            throw new IllegalArgumentException("Wrong number of variables");
        }
        int i = 0;
        while (i < this.gjep.length) {
            int j = 0;
            while (j < this.variables.length) {
                this.gjep[i].addVariable(this.variables[j], x[j]);
                ++j;
            }
            this.grad.set(i, this.gjep[i].getValue());
            ++i;
        }
        return this.grad;
    }

    @Override
    public IDoubleArray grad(IDoubleArray x) {
        return this.grad(x.getArray());
    }
}

